package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

public class SetStoreSupplyChannels {
  private List<ResourceIdentifierInput> supplyChannels;

  public SetStoreSupplyChannels() {
  }

  public SetStoreSupplyChannels(List<ResourceIdentifierInput> supplyChannels) {
    this.supplyChannels = supplyChannels;
  }

  public List<ResourceIdentifierInput> getSupplyChannels() {
    return supplyChannels;
  }

  public void setSupplyChannels(List<ResourceIdentifierInput> supplyChannels) {
    this.supplyChannels = supplyChannels;
  }

  @Override
  public String toString() {
    return "SetStoreSupplyChannels{supplyChannels='" + supplyChannels + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetStoreSupplyChannels that = (SetStoreSupplyChannels) o;
    return Objects.equals(supplyChannels, that.supplyChannels);
  }

  @Override
  public int hashCode() {
    return Objects.hash(supplyChannels);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private List<ResourceIdentifierInput> supplyChannels;

    public SetStoreSupplyChannels build() {
      SetStoreSupplyChannels result = new SetStoreSupplyChannels();
      result.supplyChannels = this.supplyChannels;
      return result;
    }

    public Builder supplyChannels(List<ResourceIdentifierInput> supplyChannels) {
      this.supplyChannels = supplyChannels;
      return this;
    }
  }
}
