package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

public class SetSubscriptionChanges {
  private List<ChangeSubscriptionInput> changes;

  public SetSubscriptionChanges() {
  }

  public SetSubscriptionChanges(List<ChangeSubscriptionInput> changes) {
    this.changes = changes;
  }

  public List<ChangeSubscriptionInput> getChanges() {
    return changes;
  }

  public void setChanges(List<ChangeSubscriptionInput> changes) {
    this.changes = changes;
  }

  @Override
  public String toString() {
    return "SetSubscriptionChanges{changes='" + changes + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetSubscriptionChanges that = (SetSubscriptionChanges) o;
    return Objects.equals(changes, that.changes);
  }

  @Override
  public int hashCode() {
    return Objects.hash(changes);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private List<ChangeSubscriptionInput> changes;

    public SetSubscriptionChanges build() {
      SetSubscriptionChanges result = new SetSubscriptionChanges();
      result.changes = this.changes;
      return result;
    }

    public Builder changes(List<ChangeSubscriptionInput> changes) {
      this.changes = changes;
      return this;
    }
  }
}
