package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class SetType implements com.commercetools.graphql.api.types.FieldType {
  private FieldType elementType;

  private String name;

  public SetType() {
  }

  public SetType(FieldType elementType, String name) {
    this.elementType = elementType;
    this.name = name;
  }

  public FieldType getElementType() {
    return elementType;
  }

  public void setElementType(FieldType elementType) {
    this.elementType = elementType;
  }

  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  @Override
  public String toString() {
    return "SetType{elementType='" + elementType + "', name='" + name + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetType that = (SetType) o;
    return Objects.equals(elementType, that.elementType) &&
        Objects.equals(name, that.name);
  }

  @Override
  public int hashCode() {
    return Objects.hash(elementType, name);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private FieldType elementType;

    private String name;

    public SetType build() {
      SetType result = new SetType();
      result.elementType = this.elementType;
      result.name = this.name;
      return result;
    }

    public Builder elementType(FieldType elementType) {
      this.elementType = elementType;
      return this;
    }

    public Builder name(String name) {
      this.name = name;
      return this;
    }
  }
}
