package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

public class SetTypeDescription {
  private List<LocalizedStringItemInputType> description;

  public SetTypeDescription() {
  }

  public SetTypeDescription(List<LocalizedStringItemInputType> description) {
    this.description = description;
  }

  public List<LocalizedStringItemInputType> getDescription() {
    return description;
  }

  public void setDescription(List<LocalizedStringItemInputType> description) {
    this.description = description;
  }

  @Override
  public String toString() {
    return "SetTypeDescription{description='" + description + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetTypeDescription that = (SetTypeDescription) o;
    return Objects.equals(description, that.description);
  }

  @Override
  public int hashCode() {
    return Objects.hash(description);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private List<LocalizedStringItemInputType> description;

    public SetTypeDescription build() {
      SetTypeDescription result = new SetTypeDescription();
      result.description = this.description;
      return result;
    }

    public Builder description(List<LocalizedStringItemInputType> description) {
      this.description = description;
      return this;
    }
  }
}
