package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class Shipping {
  private String shippingKey;

  private ShippingInfo shippingInfo;

  private Address shippingAddress;

  private ShippingRateInput shippingRateInput;

  private CustomFieldsType shippingCustomFields;

  public Shipping() {
  }

  public Shipping(String shippingKey, ShippingInfo shippingInfo, Address shippingAddress,
      ShippingRateInput shippingRateInput, CustomFieldsType shippingCustomFields) {
    this.shippingKey = shippingKey;
    this.shippingInfo = shippingInfo;
    this.shippingAddress = shippingAddress;
    this.shippingRateInput = shippingRateInput;
    this.shippingCustomFields = shippingCustomFields;
  }

  public String getShippingKey() {
    return shippingKey;
  }

  public void setShippingKey(String shippingKey) {
    this.shippingKey = shippingKey;
  }

  public ShippingInfo getShippingInfo() {
    return shippingInfo;
  }

  public void setShippingInfo(ShippingInfo shippingInfo) {
    this.shippingInfo = shippingInfo;
  }

  public Address getShippingAddress() {
    return shippingAddress;
  }

  public void setShippingAddress(Address shippingAddress) {
    this.shippingAddress = shippingAddress;
  }

  public ShippingRateInput getShippingRateInput() {
    return shippingRateInput;
  }

  public void setShippingRateInput(ShippingRateInput shippingRateInput) {
    this.shippingRateInput = shippingRateInput;
  }

  public CustomFieldsType getShippingCustomFields() {
    return shippingCustomFields;
  }

  public void setShippingCustomFields(CustomFieldsType shippingCustomFields) {
    this.shippingCustomFields = shippingCustomFields;
  }

  @Override
  public String toString() {
    return "Shipping{shippingKey='" + shippingKey + "', shippingInfo='" + shippingInfo + "', shippingAddress='" + shippingAddress + "', shippingRateInput='" + shippingRateInput + "', shippingCustomFields='" + shippingCustomFields + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    Shipping that = (Shipping) o;
    return Objects.equals(shippingKey, that.shippingKey) &&
        Objects.equals(shippingInfo, that.shippingInfo) &&
        Objects.equals(shippingAddress, that.shippingAddress) &&
        Objects.equals(shippingRateInput, that.shippingRateInput) &&
        Objects.equals(shippingCustomFields, that.shippingCustomFields);
  }

  @Override
  public int hashCode() {
    return Objects.hash(shippingKey, shippingInfo, shippingAddress, shippingRateInput, shippingCustomFields);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String shippingKey;

    private ShippingInfo shippingInfo;

    private Address shippingAddress;

    private ShippingRateInput shippingRateInput;

    private CustomFieldsType shippingCustomFields;

    public Shipping build() {
      Shipping result = new Shipping();
      result.shippingKey = this.shippingKey;
      result.shippingInfo = this.shippingInfo;
      result.shippingAddress = this.shippingAddress;
      result.shippingRateInput = this.shippingRateInput;
      result.shippingCustomFields = this.shippingCustomFields;
      return result;
    }

    public Builder shippingKey(String shippingKey) {
      this.shippingKey = shippingKey;
      return this;
    }

    public Builder shippingInfo(ShippingInfo shippingInfo) {
      this.shippingInfo = shippingInfo;
      return this;
    }

    public Builder shippingAddress(Address shippingAddress) {
      this.shippingAddress = shippingAddress;
      return this;
    }

    public Builder shippingRateInput(ShippingRateInput shippingRateInput) {
      this.shippingRateInput = shippingRateInput;
      return this;
    }

    public Builder shippingCustomFields(CustomFieldsType shippingCustomFields) {
      this.shippingCustomFields = shippingCustomFields;
      return this;
    }
  }
}
