package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Boolean;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class ShippingMethod implements com.commercetools.graphql.api.types.Versioned, com.commercetools.graphql.api.types.ReferenceExpandable {
  private String name;

  private List<ZoneRate> zoneRates;

  private Boolean active;

  private Boolean isDefault;

  private String predicate;

  private String key;

  private Reference taxCategoryRef;

  private List<LocalizedString> localizedDescriptionAllLocales;

  private List<LocalizedString> localizedNameAllLocales;

  private String localizedDescription;

  private String localizedName;

  private TaxCategory taxCategory;

  private CustomFieldsType custom;

  private String id;

  private Long version;

  private OffsetDateTime createdAt;

  private OffsetDateTime lastModifiedAt;

  private Initiator createdBy;

  private Initiator lastModifiedBy;

  public ShippingMethod() {
  }

  public ShippingMethod(String name, List<ZoneRate> zoneRates, Boolean active, Boolean isDefault,
      String predicate, String key, Reference taxCategoryRef,
      List<LocalizedString> localizedDescriptionAllLocales,
      List<LocalizedString> localizedNameAllLocales, String localizedDescription,
      String localizedName, TaxCategory taxCategory, CustomFieldsType custom, String id,
      Long version, OffsetDateTime createdAt, OffsetDateTime lastModifiedAt, Initiator createdBy,
      Initiator lastModifiedBy) {
    this.name = name;
    this.zoneRates = zoneRates;
    this.active = active;
    this.isDefault = isDefault;
    this.predicate = predicate;
    this.key = key;
    this.taxCategoryRef = taxCategoryRef;
    this.localizedDescriptionAllLocales = localizedDescriptionAllLocales;
    this.localizedNameAllLocales = localizedNameAllLocales;
    this.localizedDescription = localizedDescription;
    this.localizedName = localizedName;
    this.taxCategory = taxCategory;
    this.custom = custom;
    this.id = id;
    this.version = version;
    this.createdAt = createdAt;
    this.lastModifiedAt = lastModifiedAt;
    this.createdBy = createdBy;
    this.lastModifiedBy = lastModifiedBy;
  }

  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public List<ZoneRate> getZoneRates() {
    return zoneRates;
  }

  public void setZoneRates(List<ZoneRate> zoneRates) {
    this.zoneRates = zoneRates;
  }

  public Boolean getActive() {
    return active;
  }

  public void setActive(Boolean active) {
    this.active = active;
  }

  public Boolean getIsDefault() {
    return isDefault;
  }

  public void setIsDefault(Boolean isDefault) {
    this.isDefault = isDefault;
  }

  public String getPredicate() {
    return predicate;
  }

  public void setPredicate(String predicate) {
    this.predicate = predicate;
  }

  public String getKey() {
    return key;
  }

  public void setKey(String key) {
    this.key = key;
  }

  public Reference getTaxCategoryRef() {
    return taxCategoryRef;
  }

  public void setTaxCategoryRef(Reference taxCategoryRef) {
    this.taxCategoryRef = taxCategoryRef;
  }

  public List<LocalizedString> getLocalizedDescriptionAllLocales() {
    return localizedDescriptionAllLocales;
  }

  public void setLocalizedDescriptionAllLocales(
      List<LocalizedString> localizedDescriptionAllLocales) {
    this.localizedDescriptionAllLocales = localizedDescriptionAllLocales;
  }

  public List<LocalizedString> getLocalizedNameAllLocales() {
    return localizedNameAllLocales;
  }

  public void setLocalizedNameAllLocales(List<LocalizedString> localizedNameAllLocales) {
    this.localizedNameAllLocales = localizedNameAllLocales;
  }

  public String getLocalizedDescription() {
    return localizedDescription;
  }

  public void setLocalizedDescription(String localizedDescription) {
    this.localizedDescription = localizedDescription;
  }

  public String getLocalizedName() {
    return localizedName;
  }

  public void setLocalizedName(String localizedName) {
    this.localizedName = localizedName;
  }

  public TaxCategory getTaxCategory() {
    return taxCategory;
  }

  public void setTaxCategory(TaxCategory taxCategory) {
    this.taxCategory = taxCategory;
  }

  public CustomFieldsType getCustom() {
    return custom;
  }

  public void setCustom(CustomFieldsType custom) {
    this.custom = custom;
  }

  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }

  public Long getVersion() {
    return version;
  }

  public void setVersion(Long version) {
    this.version = version;
  }

  public OffsetDateTime getCreatedAt() {
    return createdAt;
  }

  public void setCreatedAt(OffsetDateTime createdAt) {
    this.createdAt = createdAt;
  }

  public OffsetDateTime getLastModifiedAt() {
    return lastModifiedAt;
  }

  public void setLastModifiedAt(OffsetDateTime lastModifiedAt) {
    this.lastModifiedAt = lastModifiedAt;
  }

  public Initiator getCreatedBy() {
    return createdBy;
  }

  public void setCreatedBy(Initiator createdBy) {
    this.createdBy = createdBy;
  }

  public Initiator getLastModifiedBy() {
    return lastModifiedBy;
  }

  public void setLastModifiedBy(Initiator lastModifiedBy) {
    this.lastModifiedBy = lastModifiedBy;
  }

  @Override
  public String toString() {
    return "ShippingMethod{name='" + name + "', zoneRates='" + zoneRates + "', active='" + active + "', isDefault='" + isDefault + "', predicate='" + predicate + "', key='" + key + "', taxCategoryRef='" + taxCategoryRef + "', localizedDescriptionAllLocales='" + localizedDescriptionAllLocales + "', localizedNameAllLocales='" + localizedNameAllLocales + "', localizedDescription='" + localizedDescription + "', localizedName='" + localizedName + "', taxCategory='" + taxCategory + "', custom='" + custom + "', id='" + id + "', version='" + version + "', createdAt='" + createdAt + "', lastModifiedAt='" + lastModifiedAt + "', createdBy='" + createdBy + "', lastModifiedBy='" + lastModifiedBy + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ShippingMethod that = (ShippingMethod) o;
    return Objects.equals(name, that.name) &&
        Objects.equals(zoneRates, that.zoneRates) &&
        Objects.equals(active, that.active) &&
        Objects.equals(isDefault, that.isDefault) &&
        Objects.equals(predicate, that.predicate) &&
        Objects.equals(key, that.key) &&
        Objects.equals(taxCategoryRef, that.taxCategoryRef) &&
        Objects.equals(localizedDescriptionAllLocales, that.localizedDescriptionAllLocales) &&
        Objects.equals(localizedNameAllLocales, that.localizedNameAllLocales) &&
        Objects.equals(localizedDescription, that.localizedDescription) &&
        Objects.equals(localizedName, that.localizedName) &&
        Objects.equals(taxCategory, that.taxCategory) &&
        Objects.equals(custom, that.custom) &&
        Objects.equals(id, that.id) &&
        Objects.equals(version, that.version) &&
        Objects.equals(createdAt, that.createdAt) &&
        Objects.equals(lastModifiedAt, that.lastModifiedAt) &&
        Objects.equals(createdBy, that.createdBy) &&
        Objects.equals(lastModifiedBy, that.lastModifiedBy);
  }

  @Override
  public int hashCode() {
    return Objects.hash(name, zoneRates, active, isDefault, predicate, key, taxCategoryRef, localizedDescriptionAllLocales, localizedNameAllLocales, localizedDescription, localizedName, taxCategory, custom, id, version, createdAt, lastModifiedAt, createdBy, lastModifiedBy);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String name;

    private List<ZoneRate> zoneRates;

    private Boolean active;

    private Boolean isDefault;

    private String predicate;

    private String key;

    private Reference taxCategoryRef;

    private List<LocalizedString> localizedDescriptionAllLocales;

    private List<LocalizedString> localizedNameAllLocales;

    private String localizedDescription;

    private String localizedName;

    private TaxCategory taxCategory;

    private CustomFieldsType custom;

    private String id;

    private Long version;

    private OffsetDateTime createdAt;

    private OffsetDateTime lastModifiedAt;

    private Initiator createdBy;

    private Initiator lastModifiedBy;

    public ShippingMethod build() {
      ShippingMethod result = new ShippingMethod();
      result.name = this.name;
      result.zoneRates = this.zoneRates;
      result.active = this.active;
      result.isDefault = this.isDefault;
      result.predicate = this.predicate;
      result.key = this.key;
      result.taxCategoryRef = this.taxCategoryRef;
      result.localizedDescriptionAllLocales = this.localizedDescriptionAllLocales;
      result.localizedNameAllLocales = this.localizedNameAllLocales;
      result.localizedDescription = this.localizedDescription;
      result.localizedName = this.localizedName;
      result.taxCategory = this.taxCategory;
      result.custom = this.custom;
      result.id = this.id;
      result.version = this.version;
      result.createdAt = this.createdAt;
      result.lastModifiedAt = this.lastModifiedAt;
      result.createdBy = this.createdBy;
      result.lastModifiedBy = this.lastModifiedBy;
      return result;
    }

    public Builder name(String name) {
      this.name = name;
      return this;
    }

    public Builder zoneRates(List<ZoneRate> zoneRates) {
      this.zoneRates = zoneRates;
      return this;
    }

    public Builder active(Boolean active) {
      this.active = active;
      return this;
    }

    public Builder isDefault(Boolean isDefault) {
      this.isDefault = isDefault;
      return this;
    }

    public Builder predicate(String predicate) {
      this.predicate = predicate;
      return this;
    }

    public Builder key(String key) {
      this.key = key;
      return this;
    }

    public Builder taxCategoryRef(Reference taxCategoryRef) {
      this.taxCategoryRef = taxCategoryRef;
      return this;
    }

    public Builder localizedDescriptionAllLocales(
        List<LocalizedString> localizedDescriptionAllLocales) {
      this.localizedDescriptionAllLocales = localizedDescriptionAllLocales;
      return this;
    }

    public Builder localizedNameAllLocales(List<LocalizedString> localizedNameAllLocales) {
      this.localizedNameAllLocales = localizedNameAllLocales;
      return this;
    }

    public Builder localizedDescription(String localizedDescription) {
      this.localizedDescription = localizedDescription;
      return this;
    }

    public Builder localizedName(String localizedName) {
      this.localizedName = localizedName;
      return this;
    }

    public Builder taxCategory(TaxCategory taxCategory) {
      this.taxCategory = taxCategory;
      return this;
    }

    public Builder custom(CustomFieldsType custom) {
      this.custom = custom;
      return this;
    }

    public Builder id(String id) {
      this.id = id;
      return this;
    }

    public Builder version(Long version) {
      this.version = version;
      return this;
    }

    public Builder createdAt(OffsetDateTime createdAt) {
      this.createdAt = createdAt;
      return this;
    }

    public Builder lastModifiedAt(OffsetDateTime lastModifiedAt) {
      this.lastModifiedAt = lastModifiedAt;
      return this;
    }

    public Builder createdBy(Initiator createdBy) {
      this.createdBy = createdBy;
      return this;
    }

    public Builder lastModifiedBy(Initiator lastModifiedBy) {
      this.lastModifiedBy = lastModifiedBy;
      return this;
    }
  }
}
