package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class ShippingMethodUpdateAction {
  private AddShippingMethodShippingRate addShippingRate;

  private AddShippingMethodZone addZone;

  private ChangeShippingMethodActive changeActive;

  private ChangeShippingMethodIsDefault changeIsDefault;

  private ChangeShippingMethodName changeName;

  private ChangeShippingMethodTaxCategory changeTaxCategory;

  private RemoveShippingMethodShippingRate removeShippingRate;

  private RemoveShippingMethodZone removeZone;

  private SetShippingMethodCustomField setCustomField;

  private SetShippingMethodCustomType setCustomType;

  /**
   * This action is deprecated in favor of using 'setLocalizedDescription'
   */
  private SetShippingMethodDescription setDescription;

  private SetShippingMethodKey setKey;

  private SetShippingMethodLocalizedDescription setLocalizedDescription;

  private SetShippingMethodLocalizedName setLocalizedName;

  private SetShippingMethodPredicate setPredicate;

  public ShippingMethodUpdateAction() {
  }

  public ShippingMethodUpdateAction(AddShippingMethodShippingRate addShippingRate,
      AddShippingMethodZone addZone, ChangeShippingMethodActive changeActive,
      ChangeShippingMethodIsDefault changeIsDefault, ChangeShippingMethodName changeName,
      ChangeShippingMethodTaxCategory changeTaxCategory,
      RemoveShippingMethodShippingRate removeShippingRate, RemoveShippingMethodZone removeZone,
      SetShippingMethodCustomField setCustomField, SetShippingMethodCustomType setCustomType,
      SetShippingMethodDescription setDescription, SetShippingMethodKey setKey,
      SetShippingMethodLocalizedDescription setLocalizedDescription,
      SetShippingMethodLocalizedName setLocalizedName, SetShippingMethodPredicate setPredicate) {
    this.addShippingRate = addShippingRate;
    this.addZone = addZone;
    this.changeActive = changeActive;
    this.changeIsDefault = changeIsDefault;
    this.changeName = changeName;
    this.changeTaxCategory = changeTaxCategory;
    this.removeShippingRate = removeShippingRate;
    this.removeZone = removeZone;
    this.setCustomField = setCustomField;
    this.setCustomType = setCustomType;
    this.setDescription = setDescription;
    this.setKey = setKey;
    this.setLocalizedDescription = setLocalizedDescription;
    this.setLocalizedName = setLocalizedName;
    this.setPredicate = setPredicate;
  }

  public AddShippingMethodShippingRate getAddShippingRate() {
    return addShippingRate;
  }

  public void setAddShippingRate(AddShippingMethodShippingRate addShippingRate) {
    this.addShippingRate = addShippingRate;
  }

  public AddShippingMethodZone getAddZone() {
    return addZone;
  }

  public void setAddZone(AddShippingMethodZone addZone) {
    this.addZone = addZone;
  }

  public ChangeShippingMethodActive getChangeActive() {
    return changeActive;
  }

  public void setChangeActive(ChangeShippingMethodActive changeActive) {
    this.changeActive = changeActive;
  }

  public ChangeShippingMethodIsDefault getChangeIsDefault() {
    return changeIsDefault;
  }

  public void setChangeIsDefault(ChangeShippingMethodIsDefault changeIsDefault) {
    this.changeIsDefault = changeIsDefault;
  }

  public ChangeShippingMethodName getChangeName() {
    return changeName;
  }

  public void setChangeName(ChangeShippingMethodName changeName) {
    this.changeName = changeName;
  }

  public ChangeShippingMethodTaxCategory getChangeTaxCategory() {
    return changeTaxCategory;
  }

  public void setChangeTaxCategory(ChangeShippingMethodTaxCategory changeTaxCategory) {
    this.changeTaxCategory = changeTaxCategory;
  }

  public RemoveShippingMethodShippingRate getRemoveShippingRate() {
    return removeShippingRate;
  }

  public void setRemoveShippingRate(RemoveShippingMethodShippingRate removeShippingRate) {
    this.removeShippingRate = removeShippingRate;
  }

  public RemoveShippingMethodZone getRemoveZone() {
    return removeZone;
  }

  public void setRemoveZone(RemoveShippingMethodZone removeZone) {
    this.removeZone = removeZone;
  }

  public SetShippingMethodCustomField getSetCustomField() {
    return setCustomField;
  }

  public void setSetCustomField(SetShippingMethodCustomField setCustomField) {
    this.setCustomField = setCustomField;
  }

  public SetShippingMethodCustomType getSetCustomType() {
    return setCustomType;
  }

  public void setSetCustomType(SetShippingMethodCustomType setCustomType) {
    this.setCustomType = setCustomType;
  }

  /**
   * This action is deprecated in favor of using 'setLocalizedDescription'
   */
  public SetShippingMethodDescription getSetDescription() {
    return setDescription;
  }

  public void setSetDescription(SetShippingMethodDescription setDescription) {
    this.setDescription = setDescription;
  }

  public SetShippingMethodKey getSetKey() {
    return setKey;
  }

  public void setSetKey(SetShippingMethodKey setKey) {
    this.setKey = setKey;
  }

  public SetShippingMethodLocalizedDescription getSetLocalizedDescription() {
    return setLocalizedDescription;
  }

  public void setSetLocalizedDescription(
      SetShippingMethodLocalizedDescription setLocalizedDescription) {
    this.setLocalizedDescription = setLocalizedDescription;
  }

  public SetShippingMethodLocalizedName getSetLocalizedName() {
    return setLocalizedName;
  }

  public void setSetLocalizedName(SetShippingMethodLocalizedName setLocalizedName) {
    this.setLocalizedName = setLocalizedName;
  }

  public SetShippingMethodPredicate getSetPredicate() {
    return setPredicate;
  }

  public void setSetPredicate(SetShippingMethodPredicate setPredicate) {
    this.setPredicate = setPredicate;
  }

  @Override
  public String toString() {
    return "ShippingMethodUpdateAction{addShippingRate='" + addShippingRate + "', addZone='" + addZone + "', changeActive='" + changeActive + "', changeIsDefault='" + changeIsDefault + "', changeName='" + changeName + "', changeTaxCategory='" + changeTaxCategory + "', removeShippingRate='" + removeShippingRate + "', removeZone='" + removeZone + "', setCustomField='" + setCustomField + "', setCustomType='" + setCustomType + "', setDescription='" + setDescription + "', setKey='" + setKey + "', setLocalizedDescription='" + setLocalizedDescription + "', setLocalizedName='" + setLocalizedName + "', setPredicate='" + setPredicate + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ShippingMethodUpdateAction that = (ShippingMethodUpdateAction) o;
    return Objects.equals(addShippingRate, that.addShippingRate) &&
        Objects.equals(addZone, that.addZone) &&
        Objects.equals(changeActive, that.changeActive) &&
        Objects.equals(changeIsDefault, that.changeIsDefault) &&
        Objects.equals(changeName, that.changeName) &&
        Objects.equals(changeTaxCategory, that.changeTaxCategory) &&
        Objects.equals(removeShippingRate, that.removeShippingRate) &&
        Objects.equals(removeZone, that.removeZone) &&
        Objects.equals(setCustomField, that.setCustomField) &&
        Objects.equals(setCustomType, that.setCustomType) &&
        Objects.equals(setDescription, that.setDescription) &&
        Objects.equals(setKey, that.setKey) &&
        Objects.equals(setLocalizedDescription, that.setLocalizedDescription) &&
        Objects.equals(setLocalizedName, that.setLocalizedName) &&
        Objects.equals(setPredicate, that.setPredicate);
  }

  @Override
  public int hashCode() {
    return Objects.hash(addShippingRate, addZone, changeActive, changeIsDefault, changeName, changeTaxCategory, removeShippingRate, removeZone, setCustomField, setCustomType, setDescription, setKey, setLocalizedDescription, setLocalizedName, setPredicate);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private AddShippingMethodShippingRate addShippingRate;

    private AddShippingMethodZone addZone;

    private ChangeShippingMethodActive changeActive;

    private ChangeShippingMethodIsDefault changeIsDefault;

    private ChangeShippingMethodName changeName;

    private ChangeShippingMethodTaxCategory changeTaxCategory;

    private RemoveShippingMethodShippingRate removeShippingRate;

    private RemoveShippingMethodZone removeZone;

    private SetShippingMethodCustomField setCustomField;

    private SetShippingMethodCustomType setCustomType;

    /**
     * This action is deprecated in favor of using 'setLocalizedDescription'
     */
    private SetShippingMethodDescription setDescription;

    private SetShippingMethodKey setKey;

    private SetShippingMethodLocalizedDescription setLocalizedDescription;

    private SetShippingMethodLocalizedName setLocalizedName;

    private SetShippingMethodPredicate setPredicate;

    public ShippingMethodUpdateAction build() {
      ShippingMethodUpdateAction result = new ShippingMethodUpdateAction();
      result.addShippingRate = this.addShippingRate;
      result.addZone = this.addZone;
      result.changeActive = this.changeActive;
      result.changeIsDefault = this.changeIsDefault;
      result.changeName = this.changeName;
      result.changeTaxCategory = this.changeTaxCategory;
      result.removeShippingRate = this.removeShippingRate;
      result.removeZone = this.removeZone;
      result.setCustomField = this.setCustomField;
      result.setCustomType = this.setCustomType;
      result.setDescription = this.setDescription;
      result.setKey = this.setKey;
      result.setLocalizedDescription = this.setLocalizedDescription;
      result.setLocalizedName = this.setLocalizedName;
      result.setPredicate = this.setPredicate;
      return result;
    }

    public Builder addShippingRate(AddShippingMethodShippingRate addShippingRate) {
      this.addShippingRate = addShippingRate;
      return this;
    }

    public Builder addZone(AddShippingMethodZone addZone) {
      this.addZone = addZone;
      return this;
    }

    public Builder changeActive(ChangeShippingMethodActive changeActive) {
      this.changeActive = changeActive;
      return this;
    }

    public Builder changeIsDefault(ChangeShippingMethodIsDefault changeIsDefault) {
      this.changeIsDefault = changeIsDefault;
      return this;
    }

    public Builder changeName(ChangeShippingMethodName changeName) {
      this.changeName = changeName;
      return this;
    }

    public Builder changeTaxCategory(ChangeShippingMethodTaxCategory changeTaxCategory) {
      this.changeTaxCategory = changeTaxCategory;
      return this;
    }

    public Builder removeShippingRate(RemoveShippingMethodShippingRate removeShippingRate) {
      this.removeShippingRate = removeShippingRate;
      return this;
    }

    public Builder removeZone(RemoveShippingMethodZone removeZone) {
      this.removeZone = removeZone;
      return this;
    }

    public Builder setCustomField(SetShippingMethodCustomField setCustomField) {
      this.setCustomField = setCustomField;
      return this;
    }

    public Builder setCustomType(SetShippingMethodCustomType setCustomType) {
      this.setCustomType = setCustomType;
      return this;
    }

    /**
     * This action is deprecated in favor of using 'setLocalizedDescription'
     */
    public Builder setDescription(SetShippingMethodDescription setDescription) {
      this.setDescription = setDescription;
      return this;
    }

    public Builder setKey(SetShippingMethodKey setKey) {
      this.setKey = setKey;
      return this;
    }

    public Builder setLocalizedDescription(
        SetShippingMethodLocalizedDescription setLocalizedDescription) {
      this.setLocalizedDescription = setLocalizedDescription;
      return this;
    }

    public Builder setLocalizedName(SetShippingMethodLocalizedName setLocalizedName) {
      this.setLocalizedName = setLocalizedName;
      return this;
    }

    public Builder setPredicate(SetShippingMethodPredicate setPredicate) {
      this.setPredicate = setPredicate;
      return this;
    }
  }
}
