package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.List;

/**
 * A field to retrieve available shipping methods for a cart.
 */
@JsonTypeInfo(
    use = JsonTypeInfo.Id.NAME,
    include = JsonTypeInfo.As.PROPERTY,
    property = "__typename"
)
@JsonSubTypes(@JsonSubTypes.Type(value = InStore.class, name = "InStore"))
public interface ShippingMethodsByCartInterface {
  List<ShippingMethod> getShippingMethodsByCart();

  void setShippingMethodsByCart(List<ShippingMethod> shippingMethodsByCart);
}
