package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class ShippingRateCartClassificationPriceTier implements com.commercetools.graphql.api.types.ShippingRatePriceTier {
  private String value;

  private Money price;

  private Boolean isMatching;

  private String type;

  public ShippingRateCartClassificationPriceTier() {
  }

  public ShippingRateCartClassificationPriceTier(String value, Money price, Boolean isMatching,
      String type) {
    this.value = value;
    this.price = price;
    this.isMatching = isMatching;
    this.type = type;
  }

  public String getValue() {
    return value;
  }

  public void setValue(String value) {
    this.value = value;
  }

  public Money getPrice() {
    return price;
  }

  public void setPrice(Money price) {
    this.price = price;
  }

  public Boolean getIsMatching() {
    return isMatching;
  }

  public void setIsMatching(Boolean isMatching) {
    this.isMatching = isMatching;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "ShippingRateCartClassificationPriceTier{value='" + value + "', price='" + price + "', isMatching='" + isMatching + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ShippingRateCartClassificationPriceTier that = (ShippingRateCartClassificationPriceTier) o;
    return Objects.equals(value, that.value) &&
        Objects.equals(price, that.price) &&
        Objects.equals(isMatching, that.isMatching) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(value, price, isMatching, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String value;

    private Money price;

    private Boolean isMatching;

    private String type;

    public ShippingRateCartClassificationPriceTier build() {
      ShippingRateCartClassificationPriceTier result = new ShippingRateCartClassificationPriceTier();
      result.value = this.value;
      result.price = this.price;
      result.isMatching = this.isMatching;
      result.type = this.type;
      return result;
    }

    public Builder value(String value) {
      this.value = value;
      return this;
    }

    public Builder price(Money price) {
      this.price = price;
      return this;
    }

    public Builder isMatching(Boolean isMatching) {
      this.isMatching = isMatching;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
