package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class ShippingRateCartScorePriceTier implements com.commercetools.graphql.api.types.ShippingRatePriceTier {
  private Integer score;

  private Money price;

  private PriceFunction priceFunction;

  private Boolean isMatching;

  private String type;

  public ShippingRateCartScorePriceTier() {
  }

  public ShippingRateCartScorePriceTier(Integer score, Money price, PriceFunction priceFunction,
      Boolean isMatching, String type) {
    this.score = score;
    this.price = price;
    this.priceFunction = priceFunction;
    this.isMatching = isMatching;
    this.type = type;
  }

  public Integer getScore() {
    return score;
  }

  public void setScore(Integer score) {
    this.score = score;
  }

  public Money getPrice() {
    return price;
  }

  public void setPrice(Money price) {
    this.price = price;
  }

  public PriceFunction getPriceFunction() {
    return priceFunction;
  }

  public void setPriceFunction(PriceFunction priceFunction) {
    this.priceFunction = priceFunction;
  }

  public Boolean getIsMatching() {
    return isMatching;
  }

  public void setIsMatching(Boolean isMatching) {
    this.isMatching = isMatching;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "ShippingRateCartScorePriceTier{score='" + score + "', price='" + price + "', priceFunction='" + priceFunction + "', isMatching='" + isMatching + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ShippingRateCartScorePriceTier that = (ShippingRateCartScorePriceTier) o;
    return Objects.equals(score, that.score) &&
        Objects.equals(price, that.price) &&
        Objects.equals(priceFunction, that.priceFunction) &&
        Objects.equals(isMatching, that.isMatching) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(score, price, priceFunction, isMatching, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private Integer score;

    private Money price;

    private PriceFunction priceFunction;

    private Boolean isMatching;

    private String type;

    public ShippingRateCartScorePriceTier build() {
      ShippingRateCartScorePriceTier result = new ShippingRateCartScorePriceTier();
      result.score = this.score;
      result.price = this.price;
      result.priceFunction = this.priceFunction;
      result.isMatching = this.isMatching;
      result.type = this.type;
      return result;
    }

    public Builder score(Integer score) {
      this.score = score;
      return this;
    }

    public Builder price(Money price) {
      this.price = price;
      return this;
    }

    public Builder priceFunction(PriceFunction priceFunction) {
      this.priceFunction = priceFunction;
      return this;
    }

    public Builder isMatching(Boolean isMatching) {
      this.isMatching = isMatching;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
