package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class ShippingRateDraft {
  private MoneyDraft price;

  private MoneyDraft freeAbove;

  private List<ShippingRatePriceTierDraft> tiers = Collections.emptyList();

  public ShippingRateDraft() {
  }

  public ShippingRateDraft(MoneyDraft price, MoneyDraft freeAbove,
      List<ShippingRatePriceTierDraft> tiers) {
    this.price = price;
    this.freeAbove = freeAbove;
    this.tiers = tiers;
  }

  public MoneyDraft getPrice() {
    return price;
  }

  public void setPrice(MoneyDraft price) {
    this.price = price;
  }

  public MoneyDraft getFreeAbove() {
    return freeAbove;
  }

  public void setFreeAbove(MoneyDraft freeAbove) {
    this.freeAbove = freeAbove;
  }

  public List<ShippingRatePriceTierDraft> getTiers() {
    return tiers;
  }

  public void setTiers(List<ShippingRatePriceTierDraft> tiers) {
    this.tiers = tiers;
  }

  @Override
  public String toString() {
    return "ShippingRateDraft{price='" + price + "', freeAbove='" + freeAbove + "', tiers='" + tiers + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ShippingRateDraft that = (ShippingRateDraft) o;
    return Objects.equals(price, that.price) &&
        Objects.equals(freeAbove, that.freeAbove) &&
        Objects.equals(tiers, that.tiers);
  }

  @Override
  public int hashCode() {
    return Objects.hash(price, freeAbove, tiers);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private MoneyDraft price;

    private MoneyDraft freeAbove;

    private List<ShippingRatePriceTierDraft> tiers = Collections.emptyList();

    public ShippingRateDraft build() {
      ShippingRateDraft result = new ShippingRateDraft();
      result.price = this.price;
      result.freeAbove = this.freeAbove;
      result.tiers = this.tiers;
      return result;
    }

    public Builder price(MoneyDraft price) {
      this.price = price;
      return this;
    }

    public Builder freeAbove(MoneyDraft freeAbove) {
      this.freeAbove = freeAbove;
      return this;
    }

    public Builder tiers(List<ShippingRatePriceTierDraft> tiers) {
      this.tiers = tiers;
      return this;
    }
  }
}
