package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class ShippingRateInputDraft {
  private ClassificationShippingRateInputDraft Classification;

  private ScoreShippingRateInputDraft Score;

  public ShippingRateInputDraft() {
  }

  public ShippingRateInputDraft(ClassificationShippingRateInputDraft Classification,
      ScoreShippingRateInputDraft Score) {
    this.Classification = Classification;
    this.Score = Score;
  }

  public ClassificationShippingRateInputDraft getClassification() {
    return Classification;
  }

  public void setClassification(ClassificationShippingRateInputDraft Classification) {
    this.Classification = Classification;
  }

  public ScoreShippingRateInputDraft getScore() {
    return Score;
  }

  public void setScore(ScoreShippingRateInputDraft Score) {
    this.Score = Score;
  }

  @Override
  public String toString() {
    return "ShippingRateInputDraft{Classification='" + Classification + "', Score='" + Score + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ShippingRateInputDraft that = (ShippingRateInputDraft) o;
    return Objects.equals(Classification, that.Classification) &&
        Objects.equals(Score, that.Score);
  }

  @Override
  public int hashCode() {
    return Objects.hash(Classification, Score);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private ClassificationShippingRateInputDraft Classification;

    private ScoreShippingRateInputDraft Score;

    public ShippingRateInputDraft build() {
      ShippingRateInputDraft result = new ShippingRateInputDraft();
      result.Classification = this.Classification;
      result.Score = this.Score;
      return result;
    }

    public Builder Classification(ClassificationShippingRateInputDraft Classification) {
      this.Classification = Classification;
      return this;
    }

    public Builder Score(ScoreShippingRateInputDraft Score) {
      this.Score = Score;
      return this;
    }
  }
}
