package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.String;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NAME,
    include = JsonTypeInfo.As.PROPERTY,
    property = "__typename"
)
@JsonSubTypes({
    @JsonSubTypes.Type(value = ClassificationShippingRateInputDraftOutput.class, name = "ClassificationShippingRateInputDraftOutput"),
    @JsonSubTypes.Type(value = ScoreShippingRateInputDraftOutput.class, name = "ScoreShippingRateInputDraftOutput")
})
public interface ShippingRateInputDraftOutput {
  String getType();

  void setType(String type);
}
