package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class ShippingRateInputTypeInput {
  private CartValueInput CartValue;

  private CartClassificationInput CartClassification;

  private CartScoreInput CartScore;

  public ShippingRateInputTypeInput() {
  }

  public ShippingRateInputTypeInput(CartValueInput CartValue,
      CartClassificationInput CartClassification, CartScoreInput CartScore) {
    this.CartValue = CartValue;
    this.CartClassification = CartClassification;
    this.CartScore = CartScore;
  }

  public CartValueInput getCartValue() {
    return CartValue;
  }

  public void setCartValue(CartValueInput CartValue) {
    this.CartValue = CartValue;
  }

  public CartClassificationInput getCartClassification() {
    return CartClassification;
  }

  public void setCartClassification(CartClassificationInput CartClassification) {
    this.CartClassification = CartClassification;
  }

  public CartScoreInput getCartScore() {
    return CartScore;
  }

  public void setCartScore(CartScoreInput CartScore) {
    this.CartScore = CartScore;
  }

  @Override
  public String toString() {
    return "ShippingRateInputTypeInput{CartValue='" + CartValue + "', CartClassification='" + CartClassification + "', CartScore='" + CartScore + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ShippingRateInputTypeInput that = (ShippingRateInputTypeInput) o;
    return Objects.equals(CartValue, that.CartValue) &&
        Objects.equals(CartClassification, that.CartClassification) &&
        Objects.equals(CartScore, that.CartScore);
  }

  @Override
  public int hashCode() {
    return Objects.hash(CartValue, CartClassification, CartScore);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private CartValueInput CartValue;

    private CartClassificationInput CartClassification;

    private CartScoreInput CartScore;

    public ShippingRateInputTypeInput build() {
      ShippingRateInputTypeInput result = new ShippingRateInputTypeInput();
      result.CartValue = this.CartValue;
      result.CartClassification = this.CartClassification;
      result.CartScore = this.CartScore;
      return result;
    }

    public Builder CartValue(CartValueInput CartValue) {
      this.CartValue = CartValue;
      return this;
    }

    public Builder CartClassification(CartClassificationInput CartClassification) {
      this.CartClassification = CartClassification;
      return this;
    }

    public Builder CartScore(CartScoreInput CartScore) {
      this.CartScore = CartScore;
      return this;
    }
  }
}
