package com.commercetools.graphql.api.types;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class ShippingRatePriceTierCartScoreDraft {
  private Integer score;

  private MoneyDraft price;

  private PriceFunctionDraft priceFunction;

  public ShippingRatePriceTierCartScoreDraft() {
  }

  public ShippingRatePriceTierCartScoreDraft(Integer score, MoneyDraft price,
      PriceFunctionDraft priceFunction) {
    this.score = score;
    this.price = price;
    this.priceFunction = priceFunction;
  }

  public Integer getScore() {
    return score;
  }

  public void setScore(Integer score) {
    this.score = score;
  }

  public MoneyDraft getPrice() {
    return price;
  }

  public void setPrice(MoneyDraft price) {
    this.price = price;
  }

  public PriceFunctionDraft getPriceFunction() {
    return priceFunction;
  }

  public void setPriceFunction(PriceFunctionDraft priceFunction) {
    this.priceFunction = priceFunction;
  }

  @Override
  public String toString() {
    return "ShippingRatePriceTierCartScoreDraft{score='" + score + "', price='" + price + "', priceFunction='" + priceFunction + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ShippingRatePriceTierCartScoreDraft that = (ShippingRatePriceTierCartScoreDraft) o;
    return Objects.equals(score, that.score) &&
        Objects.equals(price, that.price) &&
        Objects.equals(priceFunction, that.priceFunction);
  }

  @Override
  public int hashCode() {
    return Objects.hash(score, price, priceFunction);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private Integer score;

    private MoneyDraft price;

    private PriceFunctionDraft priceFunction;

    public ShippingRatePriceTierCartScoreDraft build() {
      ShippingRatePriceTierCartScoreDraft result = new ShippingRatePriceTierCartScoreDraft();
      result.score = this.score;
      result.price = this.price;
      result.priceFunction = this.priceFunction;
      return result;
    }

    public Builder score(Integer score) {
      this.score = score;
      return this;
    }

    public Builder price(MoneyDraft price) {
      this.price = price;
      return this;
    }

    public Builder priceFunction(PriceFunctionDraft priceFunction) {
      this.priceFunction = priceFunction;
      return this;
    }
  }
}
