package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class ShoppingList implements com.commercetools.graphql.api.types.Versioned, com.commercetools.graphql.api.types.ReferenceExpandable {
  private String key;

  private String name;

  private List<LocalizedString> nameAllLocales;

  private String description;

  private List<LocalizedString> descriptionAllLocales;

  private String slug;

  private List<LocalizedString> slugAllLocales;

  private Reference customerRef;

  private Customer customer;

  private BusinessUnit businessUnit;

  private KeyReference businessUnitRef;

  private KeyReference storeRef;

  private Store store;

  private String anonymousId;

  private List<ShoppingListLineItem> lineItems;

  private List<TextLineItem> textLineItems;

  private CustomFieldsType custom;

  private Integer deleteDaysAfterLastModification;

  private String id;

  private Long version;

  private OffsetDateTime createdAt;

  private OffsetDateTime lastModifiedAt;

  private Initiator createdBy;

  private Initiator lastModifiedBy;

  public ShoppingList() {
  }

  public ShoppingList(String key, String name, List<LocalizedString> nameAllLocales,
      String description, List<LocalizedString> descriptionAllLocales, String slug,
      List<LocalizedString> slugAllLocales, Reference customerRef, Customer customer,
      BusinessUnit businessUnit, KeyReference businessUnitRef, KeyReference storeRef, Store store,
      String anonymousId, List<ShoppingListLineItem> lineItems, List<TextLineItem> textLineItems,
      CustomFieldsType custom, Integer deleteDaysAfterLastModification, String id, Long version,
      OffsetDateTime createdAt, OffsetDateTime lastModifiedAt, Initiator createdBy,
      Initiator lastModifiedBy) {
    this.key = key;
    this.name = name;
    this.nameAllLocales = nameAllLocales;
    this.description = description;
    this.descriptionAllLocales = descriptionAllLocales;
    this.slug = slug;
    this.slugAllLocales = slugAllLocales;
    this.customerRef = customerRef;
    this.customer = customer;
    this.businessUnit = businessUnit;
    this.businessUnitRef = businessUnitRef;
    this.storeRef = storeRef;
    this.store = store;
    this.anonymousId = anonymousId;
    this.lineItems = lineItems;
    this.textLineItems = textLineItems;
    this.custom = custom;
    this.deleteDaysAfterLastModification = deleteDaysAfterLastModification;
    this.id = id;
    this.version = version;
    this.createdAt = createdAt;
    this.lastModifiedAt = lastModifiedAt;
    this.createdBy = createdBy;
    this.lastModifiedBy = lastModifiedBy;
  }

  public String getKey() {
    return key;
  }

  public void setKey(String key) {
    this.key = key;
  }

  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public List<LocalizedString> getNameAllLocales() {
    return nameAllLocales;
  }

  public void setNameAllLocales(List<LocalizedString> nameAllLocales) {
    this.nameAllLocales = nameAllLocales;
  }

  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = description;
  }

  public List<LocalizedString> getDescriptionAllLocales() {
    return descriptionAllLocales;
  }

  public void setDescriptionAllLocales(List<LocalizedString> descriptionAllLocales) {
    this.descriptionAllLocales = descriptionAllLocales;
  }

  public String getSlug() {
    return slug;
  }

  public void setSlug(String slug) {
    this.slug = slug;
  }

  public List<LocalizedString> getSlugAllLocales() {
    return slugAllLocales;
  }

  public void setSlugAllLocales(List<LocalizedString> slugAllLocales) {
    this.slugAllLocales = slugAllLocales;
  }

  public Reference getCustomerRef() {
    return customerRef;
  }

  public void setCustomerRef(Reference customerRef) {
    this.customerRef = customerRef;
  }

  public Customer getCustomer() {
    return customer;
  }

  public void setCustomer(Customer customer) {
    this.customer = customer;
  }

  public BusinessUnit getBusinessUnit() {
    return businessUnit;
  }

  public void setBusinessUnit(BusinessUnit businessUnit) {
    this.businessUnit = businessUnit;
  }

  public KeyReference getBusinessUnitRef() {
    return businessUnitRef;
  }

  public void setBusinessUnitRef(KeyReference businessUnitRef) {
    this.businessUnitRef = businessUnitRef;
  }

  public KeyReference getStoreRef() {
    return storeRef;
  }

  public void setStoreRef(KeyReference storeRef) {
    this.storeRef = storeRef;
  }

  public Store getStore() {
    return store;
  }

  public void setStore(Store store) {
    this.store = store;
  }

  public String getAnonymousId() {
    return anonymousId;
  }

  public void setAnonymousId(String anonymousId) {
    this.anonymousId = anonymousId;
  }

  public List<ShoppingListLineItem> getLineItems() {
    return lineItems;
  }

  public void setLineItems(List<ShoppingListLineItem> lineItems) {
    this.lineItems = lineItems;
  }

  public List<TextLineItem> getTextLineItems() {
    return textLineItems;
  }

  public void setTextLineItems(List<TextLineItem> textLineItems) {
    this.textLineItems = textLineItems;
  }

  public CustomFieldsType getCustom() {
    return custom;
  }

  public void setCustom(CustomFieldsType custom) {
    this.custom = custom;
  }

  public Integer getDeleteDaysAfterLastModification() {
    return deleteDaysAfterLastModification;
  }

  public void setDeleteDaysAfterLastModification(Integer deleteDaysAfterLastModification) {
    this.deleteDaysAfterLastModification = deleteDaysAfterLastModification;
  }

  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }

  public Long getVersion() {
    return version;
  }

  public void setVersion(Long version) {
    this.version = version;
  }

  public OffsetDateTime getCreatedAt() {
    return createdAt;
  }

  public void setCreatedAt(OffsetDateTime createdAt) {
    this.createdAt = createdAt;
  }

  public OffsetDateTime getLastModifiedAt() {
    return lastModifiedAt;
  }

  public void setLastModifiedAt(OffsetDateTime lastModifiedAt) {
    this.lastModifiedAt = lastModifiedAt;
  }

  public Initiator getCreatedBy() {
    return createdBy;
  }

  public void setCreatedBy(Initiator createdBy) {
    this.createdBy = createdBy;
  }

  public Initiator getLastModifiedBy() {
    return lastModifiedBy;
  }

  public void setLastModifiedBy(Initiator lastModifiedBy) {
    this.lastModifiedBy = lastModifiedBy;
  }

  @Override
  public String toString() {
    return "ShoppingList{key='" + key + "', name='" + name + "', nameAllLocales='" + nameAllLocales + "', description='" + description + "', descriptionAllLocales='" + descriptionAllLocales + "', slug='" + slug + "', slugAllLocales='" + slugAllLocales + "', customerRef='" + customerRef + "', customer='" + customer + "', businessUnit='" + businessUnit + "', businessUnitRef='" + businessUnitRef + "', storeRef='" + storeRef + "', store='" + store + "', anonymousId='" + anonymousId + "', lineItems='" + lineItems + "', textLineItems='" + textLineItems + "', custom='" + custom + "', deleteDaysAfterLastModification='" + deleteDaysAfterLastModification + "', id='" + id + "', version='" + version + "', createdAt='" + createdAt + "', lastModifiedAt='" + lastModifiedAt + "', createdBy='" + createdBy + "', lastModifiedBy='" + lastModifiedBy + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ShoppingList that = (ShoppingList) o;
    return Objects.equals(key, that.key) &&
        Objects.equals(name, that.name) &&
        Objects.equals(nameAllLocales, that.nameAllLocales) &&
        Objects.equals(description, that.description) &&
        Objects.equals(descriptionAllLocales, that.descriptionAllLocales) &&
        Objects.equals(slug, that.slug) &&
        Objects.equals(slugAllLocales, that.slugAllLocales) &&
        Objects.equals(customerRef, that.customerRef) &&
        Objects.equals(customer, that.customer) &&
        Objects.equals(businessUnit, that.businessUnit) &&
        Objects.equals(businessUnitRef, that.businessUnitRef) &&
        Objects.equals(storeRef, that.storeRef) &&
        Objects.equals(store, that.store) &&
        Objects.equals(anonymousId, that.anonymousId) &&
        Objects.equals(lineItems, that.lineItems) &&
        Objects.equals(textLineItems, that.textLineItems) &&
        Objects.equals(custom, that.custom) &&
        Objects.equals(deleteDaysAfterLastModification, that.deleteDaysAfterLastModification) &&
        Objects.equals(id, that.id) &&
        Objects.equals(version, that.version) &&
        Objects.equals(createdAt, that.createdAt) &&
        Objects.equals(lastModifiedAt, that.lastModifiedAt) &&
        Objects.equals(createdBy, that.createdBy) &&
        Objects.equals(lastModifiedBy, that.lastModifiedBy);
  }

  @Override
  public int hashCode() {
    return Objects.hash(key, name, nameAllLocales, description, descriptionAllLocales, slug, slugAllLocales, customerRef, customer, businessUnit, businessUnitRef, storeRef, store, anonymousId, lineItems, textLineItems, custom, deleteDaysAfterLastModification, id, version, createdAt, lastModifiedAt, createdBy, lastModifiedBy);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String key;

    private String name;

    private List<LocalizedString> nameAllLocales;

    private String description;

    private List<LocalizedString> descriptionAllLocales;

    private String slug;

    private List<LocalizedString> slugAllLocales;

    private Reference customerRef;

    private Customer customer;

    private BusinessUnit businessUnit;

    private KeyReference businessUnitRef;

    private KeyReference storeRef;

    private Store store;

    private String anonymousId;

    private List<ShoppingListLineItem> lineItems;

    private List<TextLineItem> textLineItems;

    private CustomFieldsType custom;

    private Integer deleteDaysAfterLastModification;

    private String id;

    private Long version;

    private OffsetDateTime createdAt;

    private OffsetDateTime lastModifiedAt;

    private Initiator createdBy;

    private Initiator lastModifiedBy;

    public ShoppingList build() {
      ShoppingList result = new ShoppingList();
      result.key = this.key;
      result.name = this.name;
      result.nameAllLocales = this.nameAllLocales;
      result.description = this.description;
      result.descriptionAllLocales = this.descriptionAllLocales;
      result.slug = this.slug;
      result.slugAllLocales = this.slugAllLocales;
      result.customerRef = this.customerRef;
      result.customer = this.customer;
      result.businessUnit = this.businessUnit;
      result.businessUnitRef = this.businessUnitRef;
      result.storeRef = this.storeRef;
      result.store = this.store;
      result.anonymousId = this.anonymousId;
      result.lineItems = this.lineItems;
      result.textLineItems = this.textLineItems;
      result.custom = this.custom;
      result.deleteDaysAfterLastModification = this.deleteDaysAfterLastModification;
      result.id = this.id;
      result.version = this.version;
      result.createdAt = this.createdAt;
      result.lastModifiedAt = this.lastModifiedAt;
      result.createdBy = this.createdBy;
      result.lastModifiedBy = this.lastModifiedBy;
      return result;
    }

    public Builder key(String key) {
      this.key = key;
      return this;
    }

    public Builder name(String name) {
      this.name = name;
      return this;
    }

    public Builder nameAllLocales(List<LocalizedString> nameAllLocales) {
      this.nameAllLocales = nameAllLocales;
      return this;
    }

    public Builder description(String description) {
      this.description = description;
      return this;
    }

    public Builder descriptionAllLocales(List<LocalizedString> descriptionAllLocales) {
      this.descriptionAllLocales = descriptionAllLocales;
      return this;
    }

    public Builder slug(String slug) {
      this.slug = slug;
      return this;
    }

    public Builder slugAllLocales(List<LocalizedString> slugAllLocales) {
      this.slugAllLocales = slugAllLocales;
      return this;
    }

    public Builder customerRef(Reference customerRef) {
      this.customerRef = customerRef;
      return this;
    }

    public Builder customer(Customer customer) {
      this.customer = customer;
      return this;
    }

    public Builder businessUnit(BusinessUnit businessUnit) {
      this.businessUnit = businessUnit;
      return this;
    }

    public Builder businessUnitRef(KeyReference businessUnitRef) {
      this.businessUnitRef = businessUnitRef;
      return this;
    }

    public Builder storeRef(KeyReference storeRef) {
      this.storeRef = storeRef;
      return this;
    }

    public Builder store(Store store) {
      this.store = store;
      return this;
    }

    public Builder anonymousId(String anonymousId) {
      this.anonymousId = anonymousId;
      return this;
    }

    public Builder lineItems(List<ShoppingListLineItem> lineItems) {
      this.lineItems = lineItems;
      return this;
    }

    public Builder textLineItems(List<TextLineItem> textLineItems) {
      this.textLineItems = textLineItems;
      return this;
    }

    public Builder custom(CustomFieldsType custom) {
      this.custom = custom;
      return this;
    }

    public Builder deleteDaysAfterLastModification(Integer deleteDaysAfterLastModification) {
      this.deleteDaysAfterLastModification = deleteDaysAfterLastModification;
      return this;
    }

    public Builder id(String id) {
      this.id = id;
      return this;
    }

    public Builder version(Long version) {
      this.version = version;
      return this;
    }

    public Builder createdAt(OffsetDateTime createdAt) {
      this.createdAt = createdAt;
      return this;
    }

    public Builder lastModifiedAt(OffsetDateTime lastModifiedAt) {
      this.lastModifiedAt = lastModifiedAt;
      return this;
    }

    public Builder createdBy(Initiator createdBy) {
      this.createdBy = createdBy;
      return this;
    }

    public Builder lastModifiedBy(Initiator lastModifiedBy) {
      this.lastModifiedBy = lastModifiedBy;
      return this;
    }
  }
}
