package com.commercetools.graphql.api.types;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Objects;

public class ShoppingListLineItem {
  private String id;

  private String key;

  private String productId;

  private Integer variantId;

  private Reference productTypeRef;

  private ProductTypeDefinition productType;

  private Integer quantity;

  private OffsetDateTime addedAt;

  private String name;

  private List<LocalizedString> nameAllLocales;

  private OffsetDateTime deactivatedAt;

  private CustomFieldsType custom;

  private String productSlug;

  private List<LocalizedString> productSlugAllLocales;

  private ProductVariant variant;

  public ShoppingListLineItem() {
  }

  public ShoppingListLineItem(String id, String key, String productId, Integer variantId,
      Reference productTypeRef, ProductTypeDefinition productType, Integer quantity,
      OffsetDateTime addedAt, String name, List<LocalizedString> nameAllLocales,
      OffsetDateTime deactivatedAt, CustomFieldsType custom, String productSlug,
      List<LocalizedString> productSlugAllLocales, ProductVariant variant) {
    this.id = id;
    this.key = key;
    this.productId = productId;
    this.variantId = variantId;
    this.productTypeRef = productTypeRef;
    this.productType = productType;
    this.quantity = quantity;
    this.addedAt = addedAt;
    this.name = name;
    this.nameAllLocales = nameAllLocales;
    this.deactivatedAt = deactivatedAt;
    this.custom = custom;
    this.productSlug = productSlug;
    this.productSlugAllLocales = productSlugAllLocales;
    this.variant = variant;
  }

  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }

  public String getKey() {
    return key;
  }

  public void setKey(String key) {
    this.key = key;
  }

  public String getProductId() {
    return productId;
  }

  public void setProductId(String productId) {
    this.productId = productId;
  }

  public Integer getVariantId() {
    return variantId;
  }

  public void setVariantId(Integer variantId) {
    this.variantId = variantId;
  }

  public Reference getProductTypeRef() {
    return productTypeRef;
  }

  public void setProductTypeRef(Reference productTypeRef) {
    this.productTypeRef = productTypeRef;
  }

  public ProductTypeDefinition getProductType() {
    return productType;
  }

  public void setProductType(ProductTypeDefinition productType) {
    this.productType = productType;
  }

  public Integer getQuantity() {
    return quantity;
  }

  public void setQuantity(Integer quantity) {
    this.quantity = quantity;
  }

  public OffsetDateTime getAddedAt() {
    return addedAt;
  }

  public void setAddedAt(OffsetDateTime addedAt) {
    this.addedAt = addedAt;
  }

  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public List<LocalizedString> getNameAllLocales() {
    return nameAllLocales;
  }

  public void setNameAllLocales(List<LocalizedString> nameAllLocales) {
    this.nameAllLocales = nameAllLocales;
  }

  public OffsetDateTime getDeactivatedAt() {
    return deactivatedAt;
  }

  public void setDeactivatedAt(OffsetDateTime deactivatedAt) {
    this.deactivatedAt = deactivatedAt;
  }

  public CustomFieldsType getCustom() {
    return custom;
  }

  public void setCustom(CustomFieldsType custom) {
    this.custom = custom;
  }

  public String getProductSlug() {
    return productSlug;
  }

  public void setProductSlug(String productSlug) {
    this.productSlug = productSlug;
  }

  public List<LocalizedString> getProductSlugAllLocales() {
    return productSlugAllLocales;
  }

  public void setProductSlugAllLocales(List<LocalizedString> productSlugAllLocales) {
    this.productSlugAllLocales = productSlugAllLocales;
  }

  public ProductVariant getVariant() {
    return variant;
  }

  public void setVariant(ProductVariant variant) {
    this.variant = variant;
  }

  @Override
  public String toString() {
    return "ShoppingListLineItem{id='" + id + "', key='" + key + "', productId='" + productId + "', variantId='" + variantId + "', productTypeRef='" + productTypeRef + "', productType='" + productType + "', quantity='" + quantity + "', addedAt='" + addedAt + "', name='" + name + "', nameAllLocales='" + nameAllLocales + "', deactivatedAt='" + deactivatedAt + "', custom='" + custom + "', productSlug='" + productSlug + "', productSlugAllLocales='" + productSlugAllLocales + "', variant='" + variant + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ShoppingListLineItem that = (ShoppingListLineItem) o;
    return Objects.equals(id, that.id) &&
        Objects.equals(key, that.key) &&
        Objects.equals(productId, that.productId) &&
        Objects.equals(variantId, that.variantId) &&
        Objects.equals(productTypeRef, that.productTypeRef) &&
        Objects.equals(productType, that.productType) &&
        Objects.equals(quantity, that.quantity) &&
        Objects.equals(addedAt, that.addedAt) &&
        Objects.equals(name, that.name) &&
        Objects.equals(nameAllLocales, that.nameAllLocales) &&
        Objects.equals(deactivatedAt, that.deactivatedAt) &&
        Objects.equals(custom, that.custom) &&
        Objects.equals(productSlug, that.productSlug) &&
        Objects.equals(productSlugAllLocales, that.productSlugAllLocales) &&
        Objects.equals(variant, that.variant);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, key, productId, variantId, productTypeRef, productType, quantity, addedAt, name, nameAllLocales, deactivatedAt, custom, productSlug, productSlugAllLocales, variant);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String id;

    private String key;

    private String productId;

    private Integer variantId;

    private Reference productTypeRef;

    private ProductTypeDefinition productType;

    private Integer quantity;

    private OffsetDateTime addedAt;

    private String name;

    private List<LocalizedString> nameAllLocales;

    private OffsetDateTime deactivatedAt;

    private CustomFieldsType custom;

    private String productSlug;

    private List<LocalizedString> productSlugAllLocales;

    private ProductVariant variant;

    public ShoppingListLineItem build() {
      ShoppingListLineItem result = new ShoppingListLineItem();
      result.id = this.id;
      result.key = this.key;
      result.productId = this.productId;
      result.variantId = this.variantId;
      result.productTypeRef = this.productTypeRef;
      result.productType = this.productType;
      result.quantity = this.quantity;
      result.addedAt = this.addedAt;
      result.name = this.name;
      result.nameAllLocales = this.nameAllLocales;
      result.deactivatedAt = this.deactivatedAt;
      result.custom = this.custom;
      result.productSlug = this.productSlug;
      result.productSlugAllLocales = this.productSlugAllLocales;
      result.variant = this.variant;
      return result;
    }

    public Builder id(String id) {
      this.id = id;
      return this;
    }

    public Builder key(String key) {
      this.key = key;
      return this;
    }

    public Builder productId(String productId) {
      this.productId = productId;
      return this;
    }

    public Builder variantId(Integer variantId) {
      this.variantId = variantId;
      return this;
    }

    public Builder productTypeRef(Reference productTypeRef) {
      this.productTypeRef = productTypeRef;
      return this;
    }

    public Builder productType(ProductTypeDefinition productType) {
      this.productType = productType;
      return this;
    }

    public Builder quantity(Integer quantity) {
      this.quantity = quantity;
      return this;
    }

    public Builder addedAt(OffsetDateTime addedAt) {
      this.addedAt = addedAt;
      return this;
    }

    public Builder name(String name) {
      this.name = name;
      return this;
    }

    public Builder nameAllLocales(List<LocalizedString> nameAllLocales) {
      this.nameAllLocales = nameAllLocales;
      return this;
    }

    public Builder deactivatedAt(OffsetDateTime deactivatedAt) {
      this.deactivatedAt = deactivatedAt;
      return this;
    }

    public Builder custom(CustomFieldsType custom) {
      this.custom = custom;
      return this;
    }

    public Builder productSlug(String productSlug) {
      this.productSlug = productSlug;
      return this;
    }

    public Builder productSlugAllLocales(List<LocalizedString> productSlugAllLocales) {
      this.productSlugAllLocales = productSlugAllLocales;
      return this;
    }

    public Builder variant(ProductVariant variant) {
      this.variant = variant;
      return this;
    }
  }
}
