package com.commercetools.graphql.api.types;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.time.OffsetDateTime;
import java.util.Objects;

public class ShoppingListLineItemDraft {
  private String productId;

  private String key;

  private String sku;

  private Integer variantId;

  private Integer quantity = 1;

  private CustomFieldsDraft custom;

  private OffsetDateTime addedAt;

  public ShoppingListLineItemDraft() {
  }

  public ShoppingListLineItemDraft(String productId, String key, String sku, Integer variantId,
      Integer quantity, CustomFieldsDraft custom, OffsetDateTime addedAt) {
    this.productId = productId;
    this.key = key;
    this.sku = sku;
    this.variantId = variantId;
    this.quantity = quantity;
    this.custom = custom;
    this.addedAt = addedAt;
  }

  public String getProductId() {
    return productId;
  }

  public void setProductId(String productId) {
    this.productId = productId;
  }

  public String getKey() {
    return key;
  }

  public void setKey(String key) {
    this.key = key;
  }

  public String getSku() {
    return sku;
  }

  public void setSku(String sku) {
    this.sku = sku;
  }

  public Integer getVariantId() {
    return variantId;
  }

  public void setVariantId(Integer variantId) {
    this.variantId = variantId;
  }

  public Integer getQuantity() {
    return quantity;
  }

  public void setQuantity(Integer quantity) {
    this.quantity = quantity;
  }

  public CustomFieldsDraft getCustom() {
    return custom;
  }

  public void setCustom(CustomFieldsDraft custom) {
    this.custom = custom;
  }

  public OffsetDateTime getAddedAt() {
    return addedAt;
  }

  public void setAddedAt(OffsetDateTime addedAt) {
    this.addedAt = addedAt;
  }

  @Override
  public String toString() {
    return "ShoppingListLineItemDraft{productId='" + productId + "', key='" + key + "', sku='" + sku + "', variantId='" + variantId + "', quantity='" + quantity + "', custom='" + custom + "', addedAt='" + addedAt + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ShoppingListLineItemDraft that = (ShoppingListLineItemDraft) o;
    return Objects.equals(productId, that.productId) &&
        Objects.equals(key, that.key) &&
        Objects.equals(sku, that.sku) &&
        Objects.equals(variantId, that.variantId) &&
        Objects.equals(quantity, that.quantity) &&
        Objects.equals(custom, that.custom) &&
        Objects.equals(addedAt, that.addedAt);
  }

  @Override
  public int hashCode() {
    return Objects.hash(productId, key, sku, variantId, quantity, custom, addedAt);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String productId;

    private String key;

    private String sku;

    private Integer variantId;

    private Integer quantity = 1;

    private CustomFieldsDraft custom;

    private OffsetDateTime addedAt;

    public ShoppingListLineItemDraft build() {
      ShoppingListLineItemDraft result = new ShoppingListLineItemDraft();
      result.productId = this.productId;
      result.key = this.key;
      result.sku = this.sku;
      result.variantId = this.variantId;
      result.quantity = this.quantity;
      result.custom = this.custom;
      result.addedAt = this.addedAt;
      return result;
    }

    public Builder productId(String productId) {
      this.productId = productId;
      return this;
    }

    public Builder key(String key) {
      this.key = key;
      return this;
    }

    public Builder sku(String sku) {
      this.sku = sku;
      return this;
    }

    public Builder variantId(Integer variantId) {
      this.variantId = variantId;
      return this;
    }

    public Builder quantity(Integer quantity) {
      this.quantity = quantity;
      return this;
    }

    public Builder custom(CustomFieldsDraft custom) {
      this.custom = custom;
      return this;
    }

    public Builder addedAt(OffsetDateTime addedAt) {
      this.addedAt = addedAt;
      return this;
    }
  }
}
