package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class ShoppingListUpdateAction {
  private AddShoppingListLineItem addLineItem;

  private AddShoppingListTextLineItem addTextLineItem;

  private ChangeShoppingListLineItemQuantity changeLineItemQuantity;

  private ChangeShoppingListLineItemsOrder changeLineItemsOrder;

  private ChangeShoppingListName changeName;

  private ChangeShoppingListTextLineItemName changeTextLineItemName;

  private ChangeShoppingListTextLineItemQuantity changeTextLineItemQuantity;

  private ChangeShoppingListTextLineItemsOrder changeTextLineItemsOrder;

  private RemoveShoppingListLineItem removeLineItem;

  private RemoveShoppingListTextLineItem removeTextLineItem;

  private SetShoppingListAnonymousId setAnonymousId;

  private SetShoppingListBusinessUnit setBusinessUnit;

  private SetShoppingListCustomField setCustomField;

  private SetShoppingListCustomType setCustomType;

  private SetShoppingListCustomer setCustomer;

  private SetShoppingListDeleteDaysAfterLastModification setDeleteDaysAfterLastModification;

  private SetShoppingListDescription setDescription;

  private SetShoppingListKey setKey;

  private SetShoppingListLineItemCustomField setLineItemCustomField;

  private SetShoppingListLineItemCustomType setLineItemCustomType;

  private SetShoppingListSlug setSlug;

  private SetShoppingListStore setStore;

  private SetShoppingListTextLineItemCustomField setTextLineItemCustomField;

  private SetShoppingListTextLineItemCustomType setTextLineItemCustomType;

  private SetShoppingListTextLineItemDescription setTextLineItemDescription;

  public ShoppingListUpdateAction() {
  }

  public ShoppingListUpdateAction(AddShoppingListLineItem addLineItem,
      AddShoppingListTextLineItem addTextLineItem,
      ChangeShoppingListLineItemQuantity changeLineItemQuantity,
      ChangeShoppingListLineItemsOrder changeLineItemsOrder, ChangeShoppingListName changeName,
      ChangeShoppingListTextLineItemName changeTextLineItemName,
      ChangeShoppingListTextLineItemQuantity changeTextLineItemQuantity,
      ChangeShoppingListTextLineItemsOrder changeTextLineItemsOrder,
      RemoveShoppingListLineItem removeLineItem, RemoveShoppingListTextLineItem removeTextLineItem,
      SetShoppingListAnonymousId setAnonymousId, SetShoppingListBusinessUnit setBusinessUnit,
      SetShoppingListCustomField setCustomField, SetShoppingListCustomType setCustomType,
      SetShoppingListCustomer setCustomer,
      SetShoppingListDeleteDaysAfterLastModification setDeleteDaysAfterLastModification,
      SetShoppingListDescription setDescription, SetShoppingListKey setKey,
      SetShoppingListLineItemCustomField setLineItemCustomField,
      SetShoppingListLineItemCustomType setLineItemCustomType, SetShoppingListSlug setSlug,
      SetShoppingListStore setStore,
      SetShoppingListTextLineItemCustomField setTextLineItemCustomField,
      SetShoppingListTextLineItemCustomType setTextLineItemCustomType,
      SetShoppingListTextLineItemDescription setTextLineItemDescription) {
    this.addLineItem = addLineItem;
    this.addTextLineItem = addTextLineItem;
    this.changeLineItemQuantity = changeLineItemQuantity;
    this.changeLineItemsOrder = changeLineItemsOrder;
    this.changeName = changeName;
    this.changeTextLineItemName = changeTextLineItemName;
    this.changeTextLineItemQuantity = changeTextLineItemQuantity;
    this.changeTextLineItemsOrder = changeTextLineItemsOrder;
    this.removeLineItem = removeLineItem;
    this.removeTextLineItem = removeTextLineItem;
    this.setAnonymousId = setAnonymousId;
    this.setBusinessUnit = setBusinessUnit;
    this.setCustomField = setCustomField;
    this.setCustomType = setCustomType;
    this.setCustomer = setCustomer;
    this.setDeleteDaysAfterLastModification = setDeleteDaysAfterLastModification;
    this.setDescription = setDescription;
    this.setKey = setKey;
    this.setLineItemCustomField = setLineItemCustomField;
    this.setLineItemCustomType = setLineItemCustomType;
    this.setSlug = setSlug;
    this.setStore = setStore;
    this.setTextLineItemCustomField = setTextLineItemCustomField;
    this.setTextLineItemCustomType = setTextLineItemCustomType;
    this.setTextLineItemDescription = setTextLineItemDescription;
  }

  public AddShoppingListLineItem getAddLineItem() {
    return addLineItem;
  }

  public void setAddLineItem(AddShoppingListLineItem addLineItem) {
    this.addLineItem = addLineItem;
  }

  public AddShoppingListTextLineItem getAddTextLineItem() {
    return addTextLineItem;
  }

  public void setAddTextLineItem(AddShoppingListTextLineItem addTextLineItem) {
    this.addTextLineItem = addTextLineItem;
  }

  public ChangeShoppingListLineItemQuantity getChangeLineItemQuantity() {
    return changeLineItemQuantity;
  }

  public void setChangeLineItemQuantity(ChangeShoppingListLineItemQuantity changeLineItemQuantity) {
    this.changeLineItemQuantity = changeLineItemQuantity;
  }

  public ChangeShoppingListLineItemsOrder getChangeLineItemsOrder() {
    return changeLineItemsOrder;
  }

  public void setChangeLineItemsOrder(ChangeShoppingListLineItemsOrder changeLineItemsOrder) {
    this.changeLineItemsOrder = changeLineItemsOrder;
  }

  public ChangeShoppingListName getChangeName() {
    return changeName;
  }

  public void setChangeName(ChangeShoppingListName changeName) {
    this.changeName = changeName;
  }

  public ChangeShoppingListTextLineItemName getChangeTextLineItemName() {
    return changeTextLineItemName;
  }

  public void setChangeTextLineItemName(ChangeShoppingListTextLineItemName changeTextLineItemName) {
    this.changeTextLineItemName = changeTextLineItemName;
  }

  public ChangeShoppingListTextLineItemQuantity getChangeTextLineItemQuantity() {
    return changeTextLineItemQuantity;
  }

  public void setChangeTextLineItemQuantity(
      ChangeShoppingListTextLineItemQuantity changeTextLineItemQuantity) {
    this.changeTextLineItemQuantity = changeTextLineItemQuantity;
  }

  public ChangeShoppingListTextLineItemsOrder getChangeTextLineItemsOrder() {
    return changeTextLineItemsOrder;
  }

  public void setChangeTextLineItemsOrder(
      ChangeShoppingListTextLineItemsOrder changeTextLineItemsOrder) {
    this.changeTextLineItemsOrder = changeTextLineItemsOrder;
  }

  public RemoveShoppingListLineItem getRemoveLineItem() {
    return removeLineItem;
  }

  public void setRemoveLineItem(RemoveShoppingListLineItem removeLineItem) {
    this.removeLineItem = removeLineItem;
  }

  public RemoveShoppingListTextLineItem getRemoveTextLineItem() {
    return removeTextLineItem;
  }

  public void setRemoveTextLineItem(RemoveShoppingListTextLineItem removeTextLineItem) {
    this.removeTextLineItem = removeTextLineItem;
  }

  public SetShoppingListAnonymousId getSetAnonymousId() {
    return setAnonymousId;
  }

  public void setSetAnonymousId(SetShoppingListAnonymousId setAnonymousId) {
    this.setAnonymousId = setAnonymousId;
  }

  public SetShoppingListBusinessUnit getSetBusinessUnit() {
    return setBusinessUnit;
  }

  public void setSetBusinessUnit(SetShoppingListBusinessUnit setBusinessUnit) {
    this.setBusinessUnit = setBusinessUnit;
  }

  public SetShoppingListCustomField getSetCustomField() {
    return setCustomField;
  }

  public void setSetCustomField(SetShoppingListCustomField setCustomField) {
    this.setCustomField = setCustomField;
  }

  public SetShoppingListCustomType getSetCustomType() {
    return setCustomType;
  }

  public void setSetCustomType(SetShoppingListCustomType setCustomType) {
    this.setCustomType = setCustomType;
  }

  public SetShoppingListCustomer getSetCustomer() {
    return setCustomer;
  }

  public void setSetCustomer(SetShoppingListCustomer setCustomer) {
    this.setCustomer = setCustomer;
  }

  public SetShoppingListDeleteDaysAfterLastModification getSetDeleteDaysAfterLastModification() {
    return setDeleteDaysAfterLastModification;
  }

  public void setSetDeleteDaysAfterLastModification(
      SetShoppingListDeleteDaysAfterLastModification setDeleteDaysAfterLastModification) {
    this.setDeleteDaysAfterLastModification = setDeleteDaysAfterLastModification;
  }

  public SetShoppingListDescription getSetDescription() {
    return setDescription;
  }

  public void setSetDescription(SetShoppingListDescription setDescription) {
    this.setDescription = setDescription;
  }

  public SetShoppingListKey getSetKey() {
    return setKey;
  }

  public void setSetKey(SetShoppingListKey setKey) {
    this.setKey = setKey;
  }

  public SetShoppingListLineItemCustomField getSetLineItemCustomField() {
    return setLineItemCustomField;
  }

  public void setSetLineItemCustomField(SetShoppingListLineItemCustomField setLineItemCustomField) {
    this.setLineItemCustomField = setLineItemCustomField;
  }

  public SetShoppingListLineItemCustomType getSetLineItemCustomType() {
    return setLineItemCustomType;
  }

  public void setSetLineItemCustomType(SetShoppingListLineItemCustomType setLineItemCustomType) {
    this.setLineItemCustomType = setLineItemCustomType;
  }

  public SetShoppingListSlug getSetSlug() {
    return setSlug;
  }

  public void setSetSlug(SetShoppingListSlug setSlug) {
    this.setSlug = setSlug;
  }

  public SetShoppingListStore getSetStore() {
    return setStore;
  }

  public void setSetStore(SetShoppingListStore setStore) {
    this.setStore = setStore;
  }

  public SetShoppingListTextLineItemCustomField getSetTextLineItemCustomField() {
    return setTextLineItemCustomField;
  }

  public void setSetTextLineItemCustomField(
      SetShoppingListTextLineItemCustomField setTextLineItemCustomField) {
    this.setTextLineItemCustomField = setTextLineItemCustomField;
  }

  public SetShoppingListTextLineItemCustomType getSetTextLineItemCustomType() {
    return setTextLineItemCustomType;
  }

  public void setSetTextLineItemCustomType(
      SetShoppingListTextLineItemCustomType setTextLineItemCustomType) {
    this.setTextLineItemCustomType = setTextLineItemCustomType;
  }

  public SetShoppingListTextLineItemDescription getSetTextLineItemDescription() {
    return setTextLineItemDescription;
  }

  public void setSetTextLineItemDescription(
      SetShoppingListTextLineItemDescription setTextLineItemDescription) {
    this.setTextLineItemDescription = setTextLineItemDescription;
  }

  @Override
  public String toString() {
    return "ShoppingListUpdateAction{addLineItem='" + addLineItem + "', addTextLineItem='" + addTextLineItem + "', changeLineItemQuantity='" + changeLineItemQuantity + "', changeLineItemsOrder='" + changeLineItemsOrder + "', changeName='" + changeName + "', changeTextLineItemName='" + changeTextLineItemName + "', changeTextLineItemQuantity='" + changeTextLineItemQuantity + "', changeTextLineItemsOrder='" + changeTextLineItemsOrder + "', removeLineItem='" + removeLineItem + "', removeTextLineItem='" + removeTextLineItem + "', setAnonymousId='" + setAnonymousId + "', setBusinessUnit='" + setBusinessUnit + "', setCustomField='" + setCustomField + "', setCustomType='" + setCustomType + "', setCustomer='" + setCustomer + "', setDeleteDaysAfterLastModification='" + setDeleteDaysAfterLastModification + "', setDescription='" + setDescription + "', setKey='" + setKey + "', setLineItemCustomField='" + setLineItemCustomField + "', setLineItemCustomType='" + setLineItemCustomType + "', setSlug='" + setSlug + "', setStore='" + setStore + "', setTextLineItemCustomField='" + setTextLineItemCustomField + "', setTextLineItemCustomType='" + setTextLineItemCustomType + "', setTextLineItemDescription='" + setTextLineItemDescription + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ShoppingListUpdateAction that = (ShoppingListUpdateAction) o;
    return Objects.equals(addLineItem, that.addLineItem) &&
        Objects.equals(addTextLineItem, that.addTextLineItem) &&
        Objects.equals(changeLineItemQuantity, that.changeLineItemQuantity) &&
        Objects.equals(changeLineItemsOrder, that.changeLineItemsOrder) &&
        Objects.equals(changeName, that.changeName) &&
        Objects.equals(changeTextLineItemName, that.changeTextLineItemName) &&
        Objects.equals(changeTextLineItemQuantity, that.changeTextLineItemQuantity) &&
        Objects.equals(changeTextLineItemsOrder, that.changeTextLineItemsOrder) &&
        Objects.equals(removeLineItem, that.removeLineItem) &&
        Objects.equals(removeTextLineItem, that.removeTextLineItem) &&
        Objects.equals(setAnonymousId, that.setAnonymousId) &&
        Objects.equals(setBusinessUnit, that.setBusinessUnit) &&
        Objects.equals(setCustomField, that.setCustomField) &&
        Objects.equals(setCustomType, that.setCustomType) &&
        Objects.equals(setCustomer, that.setCustomer) &&
        Objects.equals(setDeleteDaysAfterLastModification, that.setDeleteDaysAfterLastModification) &&
        Objects.equals(setDescription, that.setDescription) &&
        Objects.equals(setKey, that.setKey) &&
        Objects.equals(setLineItemCustomField, that.setLineItemCustomField) &&
        Objects.equals(setLineItemCustomType, that.setLineItemCustomType) &&
        Objects.equals(setSlug, that.setSlug) &&
        Objects.equals(setStore, that.setStore) &&
        Objects.equals(setTextLineItemCustomField, that.setTextLineItemCustomField) &&
        Objects.equals(setTextLineItemCustomType, that.setTextLineItemCustomType) &&
        Objects.equals(setTextLineItemDescription, that.setTextLineItemDescription);
  }

  @Override
  public int hashCode() {
    return Objects.hash(addLineItem, addTextLineItem, changeLineItemQuantity, changeLineItemsOrder, changeName, changeTextLineItemName, changeTextLineItemQuantity, changeTextLineItemsOrder, removeLineItem, removeTextLineItem, setAnonymousId, setBusinessUnit, setCustomField, setCustomType, setCustomer, setDeleteDaysAfterLastModification, setDescription, setKey, setLineItemCustomField, setLineItemCustomType, setSlug, setStore, setTextLineItemCustomField, setTextLineItemCustomType, setTextLineItemDescription);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private AddShoppingListLineItem addLineItem;

    private AddShoppingListTextLineItem addTextLineItem;

    private ChangeShoppingListLineItemQuantity changeLineItemQuantity;

    private ChangeShoppingListLineItemsOrder changeLineItemsOrder;

    private ChangeShoppingListName changeName;

    private ChangeShoppingListTextLineItemName changeTextLineItemName;

    private ChangeShoppingListTextLineItemQuantity changeTextLineItemQuantity;

    private ChangeShoppingListTextLineItemsOrder changeTextLineItemsOrder;

    private RemoveShoppingListLineItem removeLineItem;

    private RemoveShoppingListTextLineItem removeTextLineItem;

    private SetShoppingListAnonymousId setAnonymousId;

    private SetShoppingListBusinessUnit setBusinessUnit;

    private SetShoppingListCustomField setCustomField;

    private SetShoppingListCustomType setCustomType;

    private SetShoppingListCustomer setCustomer;

    private SetShoppingListDeleteDaysAfterLastModification setDeleteDaysAfterLastModification;

    private SetShoppingListDescription setDescription;

    private SetShoppingListKey setKey;

    private SetShoppingListLineItemCustomField setLineItemCustomField;

    private SetShoppingListLineItemCustomType setLineItemCustomType;

    private SetShoppingListSlug setSlug;

    private SetShoppingListStore setStore;

    private SetShoppingListTextLineItemCustomField setTextLineItemCustomField;

    private SetShoppingListTextLineItemCustomType setTextLineItemCustomType;

    private SetShoppingListTextLineItemDescription setTextLineItemDescription;

    public ShoppingListUpdateAction build() {
      ShoppingListUpdateAction result = new ShoppingListUpdateAction();
      result.addLineItem = this.addLineItem;
      result.addTextLineItem = this.addTextLineItem;
      result.changeLineItemQuantity = this.changeLineItemQuantity;
      result.changeLineItemsOrder = this.changeLineItemsOrder;
      result.changeName = this.changeName;
      result.changeTextLineItemName = this.changeTextLineItemName;
      result.changeTextLineItemQuantity = this.changeTextLineItemQuantity;
      result.changeTextLineItemsOrder = this.changeTextLineItemsOrder;
      result.removeLineItem = this.removeLineItem;
      result.removeTextLineItem = this.removeTextLineItem;
      result.setAnonymousId = this.setAnonymousId;
      result.setBusinessUnit = this.setBusinessUnit;
      result.setCustomField = this.setCustomField;
      result.setCustomType = this.setCustomType;
      result.setCustomer = this.setCustomer;
      result.setDeleteDaysAfterLastModification = this.setDeleteDaysAfterLastModification;
      result.setDescription = this.setDescription;
      result.setKey = this.setKey;
      result.setLineItemCustomField = this.setLineItemCustomField;
      result.setLineItemCustomType = this.setLineItemCustomType;
      result.setSlug = this.setSlug;
      result.setStore = this.setStore;
      result.setTextLineItemCustomField = this.setTextLineItemCustomField;
      result.setTextLineItemCustomType = this.setTextLineItemCustomType;
      result.setTextLineItemDescription = this.setTextLineItemDescription;
      return result;
    }

    public Builder addLineItem(AddShoppingListLineItem addLineItem) {
      this.addLineItem = addLineItem;
      return this;
    }

    public Builder addTextLineItem(AddShoppingListTextLineItem addTextLineItem) {
      this.addTextLineItem = addTextLineItem;
      return this;
    }

    public Builder changeLineItemQuantity(
        ChangeShoppingListLineItemQuantity changeLineItemQuantity) {
      this.changeLineItemQuantity = changeLineItemQuantity;
      return this;
    }

    public Builder changeLineItemsOrder(ChangeShoppingListLineItemsOrder changeLineItemsOrder) {
      this.changeLineItemsOrder = changeLineItemsOrder;
      return this;
    }

    public Builder changeName(ChangeShoppingListName changeName) {
      this.changeName = changeName;
      return this;
    }

    public Builder changeTextLineItemName(
        ChangeShoppingListTextLineItemName changeTextLineItemName) {
      this.changeTextLineItemName = changeTextLineItemName;
      return this;
    }

    public Builder changeTextLineItemQuantity(
        ChangeShoppingListTextLineItemQuantity changeTextLineItemQuantity) {
      this.changeTextLineItemQuantity = changeTextLineItemQuantity;
      return this;
    }

    public Builder changeTextLineItemsOrder(
        ChangeShoppingListTextLineItemsOrder changeTextLineItemsOrder) {
      this.changeTextLineItemsOrder = changeTextLineItemsOrder;
      return this;
    }

    public Builder removeLineItem(RemoveShoppingListLineItem removeLineItem) {
      this.removeLineItem = removeLineItem;
      return this;
    }

    public Builder removeTextLineItem(RemoveShoppingListTextLineItem removeTextLineItem) {
      this.removeTextLineItem = removeTextLineItem;
      return this;
    }

    public Builder setAnonymousId(SetShoppingListAnonymousId setAnonymousId) {
      this.setAnonymousId = setAnonymousId;
      return this;
    }

    public Builder setBusinessUnit(SetShoppingListBusinessUnit setBusinessUnit) {
      this.setBusinessUnit = setBusinessUnit;
      return this;
    }

    public Builder setCustomField(SetShoppingListCustomField setCustomField) {
      this.setCustomField = setCustomField;
      return this;
    }

    public Builder setCustomType(SetShoppingListCustomType setCustomType) {
      this.setCustomType = setCustomType;
      return this;
    }

    public Builder setCustomer(SetShoppingListCustomer setCustomer) {
      this.setCustomer = setCustomer;
      return this;
    }

    public Builder setDeleteDaysAfterLastModification(
        SetShoppingListDeleteDaysAfterLastModification setDeleteDaysAfterLastModification) {
      this.setDeleteDaysAfterLastModification = setDeleteDaysAfterLastModification;
      return this;
    }

    public Builder setDescription(SetShoppingListDescription setDescription) {
      this.setDescription = setDescription;
      return this;
    }

    public Builder setKey(SetShoppingListKey setKey) {
      this.setKey = setKey;
      return this;
    }

    public Builder setLineItemCustomField(
        SetShoppingListLineItemCustomField setLineItemCustomField) {
      this.setLineItemCustomField = setLineItemCustomField;
      return this;
    }

    public Builder setLineItemCustomType(SetShoppingListLineItemCustomType setLineItemCustomType) {
      this.setLineItemCustomType = setLineItemCustomType;
      return this;
    }

    public Builder setSlug(SetShoppingListSlug setSlug) {
      this.setSlug = setSlug;
      return this;
    }

    public Builder setStore(SetShoppingListStore setStore) {
      this.setStore = setStore;
      return this;
    }

    public Builder setTextLineItemCustomField(
        SetShoppingListTextLineItemCustomField setTextLineItemCustomField) {
      this.setTextLineItemCustomField = setTextLineItemCustomField;
      return this;
    }

    public Builder setTextLineItemCustomType(
        SetShoppingListTextLineItemCustomType setTextLineItemCustomType) {
      this.setTextLineItemCustomType = setTextLineItemCustomType;
      return this;
    }

    public Builder setTextLineItemDescription(
        SetShoppingListTextLineItemDescription setTextLineItemDescription) {
      this.setTextLineItemDescription = setTextLineItemDescription;
      return this;
    }
  }
}
