package com.commercetools.graphql.api.types;

import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

public class SignUpInMyBusinessUnitDraft {
  private ResourceIdentifierInput businessUnit;

  private CustomerSignUpDraft customer;

  private Long version;

  private List<AssociateRoleAssignmentDraft> associateRoleAssignments;

  public SignUpInMyBusinessUnitDraft() {
  }

  public SignUpInMyBusinessUnitDraft(ResourceIdentifierInput businessUnit,
      CustomerSignUpDraft customer, Long version,
      List<AssociateRoleAssignmentDraft> associateRoleAssignments) {
    this.businessUnit = businessUnit;
    this.customer = customer;
    this.version = version;
    this.associateRoleAssignments = associateRoleAssignments;
  }

  public ResourceIdentifierInput getBusinessUnit() {
    return businessUnit;
  }

  public void setBusinessUnit(ResourceIdentifierInput businessUnit) {
    this.businessUnit = businessUnit;
  }

  public CustomerSignUpDraft getCustomer() {
    return customer;
  }

  public void setCustomer(CustomerSignUpDraft customer) {
    this.customer = customer;
  }

  public Long getVersion() {
    return version;
  }

  public void setVersion(Long version) {
    this.version = version;
  }

  public List<AssociateRoleAssignmentDraft> getAssociateRoleAssignments() {
    return associateRoleAssignments;
  }

  public void setAssociateRoleAssignments(
      List<AssociateRoleAssignmentDraft> associateRoleAssignments) {
    this.associateRoleAssignments = associateRoleAssignments;
  }

  @Override
  public String toString() {
    return "SignUpInMyBusinessUnitDraft{businessUnit='" + businessUnit + "', customer='" + customer + "', version='" + version + "', associateRoleAssignments='" + associateRoleAssignments + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SignUpInMyBusinessUnitDraft that = (SignUpInMyBusinessUnitDraft) o;
    return Objects.equals(businessUnit, that.businessUnit) &&
        Objects.equals(customer, that.customer) &&
        Objects.equals(version, that.version) &&
        Objects.equals(associateRoleAssignments, that.associateRoleAssignments);
  }

  @Override
  public int hashCode() {
    return Objects.hash(businessUnit, customer, version, associateRoleAssignments);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private ResourceIdentifierInput businessUnit;

    private CustomerSignUpDraft customer;

    private Long version;

    private List<AssociateRoleAssignmentDraft> associateRoleAssignments;

    public SignUpInMyBusinessUnitDraft build() {
      SignUpInMyBusinessUnitDraft result = new SignUpInMyBusinessUnitDraft();
      result.businessUnit = this.businessUnit;
      result.customer = this.customer;
      result.version = this.version;
      result.associateRoleAssignments = this.associateRoleAssignments;
      return result;
    }

    public Builder businessUnit(ResourceIdentifierInput businessUnit) {
      this.businessUnit = businessUnit;
      return this;
    }

    public Builder customer(CustomerSignUpDraft customer) {
      this.customer = customer;
      return this;
    }

    public Builder version(Long version) {
      this.version = version;
      return this;
    }

    public Builder associateRoleAssignments(
        List<AssociateRoleAssignmentDraft> associateRoleAssignments) {
      this.associateRoleAssignments = associateRoleAssignments;
      return this;
    }
  }
}
