package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class SimpleFieldTypeDraft {
  private String dummy;

  public SimpleFieldTypeDraft() {
  }

  public SimpleFieldTypeDraft(String dummy) {
    this.dummy = dummy;
  }

  public String getDummy() {
    return dummy;
  }

  public void setDummy(String dummy) {
    this.dummy = dummy;
  }

  @Override
  public String toString() {
    return "SimpleFieldTypeDraft{dummy='" + dummy + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SimpleFieldTypeDraft that = (SimpleFieldTypeDraft) o;
    return Objects.equals(dummy, that.dummy);
  }

  @Override
  public int hashCode() {
    return Objects.hash(dummy);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String dummy;

    public SimpleFieldTypeDraft build() {
      SimpleFieldTypeDraft result = new SimpleFieldTypeDraft();
      result.dummy = this.dummy;
      return result;
    }

    public Builder dummy(String dummy) {
      this.dummy = dummy;
      return this;
    }
  }
}
