package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.time.OffsetDateTime;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class StagedQuote implements com.commercetools.graphql.api.types.Versioned {
  private String key;

  private StagedQuoteState stagedQuoteState;

  private Reference quoteRequestRef;

  private QuoteRequest quoteRequest;

  private Reference quotationCartRef;

  private Cart quotationCart;

  private Reference customerRef;

  private Customer customer;

  private OffsetDateTime validTo;

  private CustomFieldsType custom;

  private Reference stateRef;

  private State state;

  private String sellerComment;

  private BusinessUnit businessUnit;

  private KeyReference businessUnitRef;

  private String purchaseOrderNumber;

  private KeyReference storeRef;

  private Store store;

  private String id;

  private Long version;

  private OffsetDateTime createdAt;

  private OffsetDateTime lastModifiedAt;

  private Initiator createdBy;

  private Initiator lastModifiedBy;

  public StagedQuote() {
  }

  public StagedQuote(String key, StagedQuoteState stagedQuoteState, Reference quoteRequestRef,
      QuoteRequest quoteRequest, Reference quotationCartRef, Cart quotationCart,
      Reference customerRef, Customer customer, OffsetDateTime validTo, CustomFieldsType custom,
      Reference stateRef, State state, String sellerComment, BusinessUnit businessUnit,
      KeyReference businessUnitRef, String purchaseOrderNumber, KeyReference storeRef, Store store,
      String id, Long version, OffsetDateTime createdAt, OffsetDateTime lastModifiedAt,
      Initiator createdBy, Initiator lastModifiedBy) {
    this.key = key;
    this.stagedQuoteState = stagedQuoteState;
    this.quoteRequestRef = quoteRequestRef;
    this.quoteRequest = quoteRequest;
    this.quotationCartRef = quotationCartRef;
    this.quotationCart = quotationCart;
    this.customerRef = customerRef;
    this.customer = customer;
    this.validTo = validTo;
    this.custom = custom;
    this.stateRef = stateRef;
    this.state = state;
    this.sellerComment = sellerComment;
    this.businessUnit = businessUnit;
    this.businessUnitRef = businessUnitRef;
    this.purchaseOrderNumber = purchaseOrderNumber;
    this.storeRef = storeRef;
    this.store = store;
    this.id = id;
    this.version = version;
    this.createdAt = createdAt;
    this.lastModifiedAt = lastModifiedAt;
    this.createdBy = createdBy;
    this.lastModifiedBy = lastModifiedBy;
  }

  public String getKey() {
    return key;
  }

  public void setKey(String key) {
    this.key = key;
  }

  public StagedQuoteState getStagedQuoteState() {
    return stagedQuoteState;
  }

  public void setStagedQuoteState(StagedQuoteState stagedQuoteState) {
    this.stagedQuoteState = stagedQuoteState;
  }

  public Reference getQuoteRequestRef() {
    return quoteRequestRef;
  }

  public void setQuoteRequestRef(Reference quoteRequestRef) {
    this.quoteRequestRef = quoteRequestRef;
  }

  public QuoteRequest getQuoteRequest() {
    return quoteRequest;
  }

  public void setQuoteRequest(QuoteRequest quoteRequest) {
    this.quoteRequest = quoteRequest;
  }

  public Reference getQuotationCartRef() {
    return quotationCartRef;
  }

  public void setQuotationCartRef(Reference quotationCartRef) {
    this.quotationCartRef = quotationCartRef;
  }

  public Cart getQuotationCart() {
    return quotationCart;
  }

  public void setQuotationCart(Cart quotationCart) {
    this.quotationCart = quotationCart;
  }

  public Reference getCustomerRef() {
    return customerRef;
  }

  public void setCustomerRef(Reference customerRef) {
    this.customerRef = customerRef;
  }

  public Customer getCustomer() {
    return customer;
  }

  public void setCustomer(Customer customer) {
    this.customer = customer;
  }

  public OffsetDateTime getValidTo() {
    return validTo;
  }

  public void setValidTo(OffsetDateTime validTo) {
    this.validTo = validTo;
  }

  public CustomFieldsType getCustom() {
    return custom;
  }

  public void setCustom(CustomFieldsType custom) {
    this.custom = custom;
  }

  public Reference getStateRef() {
    return stateRef;
  }

  public void setStateRef(Reference stateRef) {
    this.stateRef = stateRef;
  }

  public State getState() {
    return state;
  }

  public void setState(State state) {
    this.state = state;
  }

  public String getSellerComment() {
    return sellerComment;
  }

  public void setSellerComment(String sellerComment) {
    this.sellerComment = sellerComment;
  }

  public BusinessUnit getBusinessUnit() {
    return businessUnit;
  }

  public void setBusinessUnit(BusinessUnit businessUnit) {
    this.businessUnit = businessUnit;
  }

  public KeyReference getBusinessUnitRef() {
    return businessUnitRef;
  }

  public void setBusinessUnitRef(KeyReference businessUnitRef) {
    this.businessUnitRef = businessUnitRef;
  }

  public String getPurchaseOrderNumber() {
    return purchaseOrderNumber;
  }

  public void setPurchaseOrderNumber(String purchaseOrderNumber) {
    this.purchaseOrderNumber = purchaseOrderNumber;
  }

  public KeyReference getStoreRef() {
    return storeRef;
  }

  public void setStoreRef(KeyReference storeRef) {
    this.storeRef = storeRef;
  }

  public Store getStore() {
    return store;
  }

  public void setStore(Store store) {
    this.store = store;
  }

  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }

  public Long getVersion() {
    return version;
  }

  public void setVersion(Long version) {
    this.version = version;
  }

  public OffsetDateTime getCreatedAt() {
    return createdAt;
  }

  public void setCreatedAt(OffsetDateTime createdAt) {
    this.createdAt = createdAt;
  }

  public OffsetDateTime getLastModifiedAt() {
    return lastModifiedAt;
  }

  public void setLastModifiedAt(OffsetDateTime lastModifiedAt) {
    this.lastModifiedAt = lastModifiedAt;
  }

  public Initiator getCreatedBy() {
    return createdBy;
  }

  public void setCreatedBy(Initiator createdBy) {
    this.createdBy = createdBy;
  }

  public Initiator getLastModifiedBy() {
    return lastModifiedBy;
  }

  public void setLastModifiedBy(Initiator lastModifiedBy) {
    this.lastModifiedBy = lastModifiedBy;
  }

  @Override
  public String toString() {
    return "StagedQuote{key='" + key + "', stagedQuoteState='" + stagedQuoteState + "', quoteRequestRef='" + quoteRequestRef + "', quoteRequest='" + quoteRequest + "', quotationCartRef='" + quotationCartRef + "', quotationCart='" + quotationCart + "', customerRef='" + customerRef + "', customer='" + customer + "', validTo='" + validTo + "', custom='" + custom + "', stateRef='" + stateRef + "', state='" + state + "', sellerComment='" + sellerComment + "', businessUnit='" + businessUnit + "', businessUnitRef='" + businessUnitRef + "', purchaseOrderNumber='" + purchaseOrderNumber + "', storeRef='" + storeRef + "', store='" + store + "', id='" + id + "', version='" + version + "', createdAt='" + createdAt + "', lastModifiedAt='" + lastModifiedAt + "', createdBy='" + createdBy + "', lastModifiedBy='" + lastModifiedBy + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    StagedQuote that = (StagedQuote) o;
    return Objects.equals(key, that.key) &&
        Objects.equals(stagedQuoteState, that.stagedQuoteState) &&
        Objects.equals(quoteRequestRef, that.quoteRequestRef) &&
        Objects.equals(quoteRequest, that.quoteRequest) &&
        Objects.equals(quotationCartRef, that.quotationCartRef) &&
        Objects.equals(quotationCart, that.quotationCart) &&
        Objects.equals(customerRef, that.customerRef) &&
        Objects.equals(customer, that.customer) &&
        Objects.equals(validTo, that.validTo) &&
        Objects.equals(custom, that.custom) &&
        Objects.equals(stateRef, that.stateRef) &&
        Objects.equals(state, that.state) &&
        Objects.equals(sellerComment, that.sellerComment) &&
        Objects.equals(businessUnit, that.businessUnit) &&
        Objects.equals(businessUnitRef, that.businessUnitRef) &&
        Objects.equals(purchaseOrderNumber, that.purchaseOrderNumber) &&
        Objects.equals(storeRef, that.storeRef) &&
        Objects.equals(store, that.store) &&
        Objects.equals(id, that.id) &&
        Objects.equals(version, that.version) &&
        Objects.equals(createdAt, that.createdAt) &&
        Objects.equals(lastModifiedAt, that.lastModifiedAt) &&
        Objects.equals(createdBy, that.createdBy) &&
        Objects.equals(lastModifiedBy, that.lastModifiedBy);
  }

  @Override
  public int hashCode() {
    return Objects.hash(key, stagedQuoteState, quoteRequestRef, quoteRequest, quotationCartRef, quotationCart, customerRef, customer, validTo, custom, stateRef, state, sellerComment, businessUnit, businessUnitRef, purchaseOrderNumber, storeRef, store, id, version, createdAt, lastModifiedAt, createdBy, lastModifiedBy);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String key;

    private StagedQuoteState stagedQuoteState;

    private Reference quoteRequestRef;

    private QuoteRequest quoteRequest;

    private Reference quotationCartRef;

    private Cart quotationCart;

    private Reference customerRef;

    private Customer customer;

    private OffsetDateTime validTo;

    private CustomFieldsType custom;

    private Reference stateRef;

    private State state;

    private String sellerComment;

    private BusinessUnit businessUnit;

    private KeyReference businessUnitRef;

    private String purchaseOrderNumber;

    private KeyReference storeRef;

    private Store store;

    private String id;

    private Long version;

    private OffsetDateTime createdAt;

    private OffsetDateTime lastModifiedAt;

    private Initiator createdBy;

    private Initiator lastModifiedBy;

    public StagedQuote build() {
      StagedQuote result = new StagedQuote();
      result.key = this.key;
      result.stagedQuoteState = this.stagedQuoteState;
      result.quoteRequestRef = this.quoteRequestRef;
      result.quoteRequest = this.quoteRequest;
      result.quotationCartRef = this.quotationCartRef;
      result.quotationCart = this.quotationCart;
      result.customerRef = this.customerRef;
      result.customer = this.customer;
      result.validTo = this.validTo;
      result.custom = this.custom;
      result.stateRef = this.stateRef;
      result.state = this.state;
      result.sellerComment = this.sellerComment;
      result.businessUnit = this.businessUnit;
      result.businessUnitRef = this.businessUnitRef;
      result.purchaseOrderNumber = this.purchaseOrderNumber;
      result.storeRef = this.storeRef;
      result.store = this.store;
      result.id = this.id;
      result.version = this.version;
      result.createdAt = this.createdAt;
      result.lastModifiedAt = this.lastModifiedAt;
      result.createdBy = this.createdBy;
      result.lastModifiedBy = this.lastModifiedBy;
      return result;
    }

    public Builder key(String key) {
      this.key = key;
      return this;
    }

    public Builder stagedQuoteState(StagedQuoteState stagedQuoteState) {
      this.stagedQuoteState = stagedQuoteState;
      return this;
    }

    public Builder quoteRequestRef(Reference quoteRequestRef) {
      this.quoteRequestRef = quoteRequestRef;
      return this;
    }

    public Builder quoteRequest(QuoteRequest quoteRequest) {
      this.quoteRequest = quoteRequest;
      return this;
    }

    public Builder quotationCartRef(Reference quotationCartRef) {
      this.quotationCartRef = quotationCartRef;
      return this;
    }

    public Builder quotationCart(Cart quotationCart) {
      this.quotationCart = quotationCart;
      return this;
    }

    public Builder customerRef(Reference customerRef) {
      this.customerRef = customerRef;
      return this;
    }

    public Builder customer(Customer customer) {
      this.customer = customer;
      return this;
    }

    public Builder validTo(OffsetDateTime validTo) {
      this.validTo = validTo;
      return this;
    }

    public Builder custom(CustomFieldsType custom) {
      this.custom = custom;
      return this;
    }

    public Builder stateRef(Reference stateRef) {
      this.stateRef = stateRef;
      return this;
    }

    public Builder state(State state) {
      this.state = state;
      return this;
    }

    public Builder sellerComment(String sellerComment) {
      this.sellerComment = sellerComment;
      return this;
    }

    public Builder businessUnit(BusinessUnit businessUnit) {
      this.businessUnit = businessUnit;
      return this;
    }

    public Builder businessUnitRef(KeyReference businessUnitRef) {
      this.businessUnitRef = businessUnitRef;
      return this;
    }

    public Builder purchaseOrderNumber(String purchaseOrderNumber) {
      this.purchaseOrderNumber = purchaseOrderNumber;
      return this;
    }

    public Builder storeRef(KeyReference storeRef) {
      this.storeRef = storeRef;
      return this;
    }

    public Builder store(Store store) {
      this.store = store;
      return this;
    }

    public Builder id(String id) {
      this.id = id;
      return this;
    }

    public Builder version(Long version) {
      this.version = version;
      return this;
    }

    public Builder createdAt(OffsetDateTime createdAt) {
      this.createdAt = createdAt;
      return this;
    }

    public Builder lastModifiedAt(OffsetDateTime lastModifiedAt) {
      this.lastModifiedAt = lastModifiedAt;
      return this;
    }

    public Builder createdBy(Initiator createdBy) {
      this.createdBy = createdBy;
      return this;
    }

    public Builder lastModifiedBy(Initiator lastModifiedBy) {
      this.lastModifiedBy = lastModifiedBy;
      return this;
    }
  }
}
