package com.commercetools.graphql.api.types;

import java.lang.Boolean;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class StagedQuoteDraft {
  private String key;

  private ResourceIdentifierInput quoteRequest;

  private Boolean quoteRequestStateToAccepted = false;

  private Long quoteRequestVersion;

  private CustomFieldsDraft custom;

  private ReferenceInput state;

  public StagedQuoteDraft() {
  }

  public StagedQuoteDraft(String key, ResourceIdentifierInput quoteRequest,
      Boolean quoteRequestStateToAccepted, Long quoteRequestVersion, CustomFieldsDraft custom,
      ReferenceInput state) {
    this.key = key;
    this.quoteRequest = quoteRequest;
    this.quoteRequestStateToAccepted = quoteRequestStateToAccepted;
    this.quoteRequestVersion = quoteRequestVersion;
    this.custom = custom;
    this.state = state;
  }

  public String getKey() {
    return key;
  }

  public void setKey(String key) {
    this.key = key;
  }

  public ResourceIdentifierInput getQuoteRequest() {
    return quoteRequest;
  }

  public void setQuoteRequest(ResourceIdentifierInput quoteRequest) {
    this.quoteRequest = quoteRequest;
  }

  public Boolean getQuoteRequestStateToAccepted() {
    return quoteRequestStateToAccepted;
  }

  public void setQuoteRequestStateToAccepted(Boolean quoteRequestStateToAccepted) {
    this.quoteRequestStateToAccepted = quoteRequestStateToAccepted;
  }

  public Long getQuoteRequestVersion() {
    return quoteRequestVersion;
  }

  public void setQuoteRequestVersion(Long quoteRequestVersion) {
    this.quoteRequestVersion = quoteRequestVersion;
  }

  public CustomFieldsDraft getCustom() {
    return custom;
  }

  public void setCustom(CustomFieldsDraft custom) {
    this.custom = custom;
  }

  public ReferenceInput getState() {
    return state;
  }

  public void setState(ReferenceInput state) {
    this.state = state;
  }

  @Override
  public String toString() {
    return "StagedQuoteDraft{key='" + key + "', quoteRequest='" + quoteRequest + "', quoteRequestStateToAccepted='" + quoteRequestStateToAccepted + "', quoteRequestVersion='" + quoteRequestVersion + "', custom='" + custom + "', state='" + state + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    StagedQuoteDraft that = (StagedQuoteDraft) o;
    return Objects.equals(key, that.key) &&
        Objects.equals(quoteRequest, that.quoteRequest) &&
        Objects.equals(quoteRequestStateToAccepted, that.quoteRequestStateToAccepted) &&
        Objects.equals(quoteRequestVersion, that.quoteRequestVersion) &&
        Objects.equals(custom, that.custom) &&
        Objects.equals(state, that.state);
  }

  @Override
  public int hashCode() {
    return Objects.hash(key, quoteRequest, quoteRequestStateToAccepted, quoteRequestVersion, custom, state);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String key;

    private ResourceIdentifierInput quoteRequest;

    private Boolean quoteRequestStateToAccepted = false;

    private Long quoteRequestVersion;

    private CustomFieldsDraft custom;

    private ReferenceInput state;

    public StagedQuoteDraft build() {
      StagedQuoteDraft result = new StagedQuoteDraft();
      result.key = this.key;
      result.quoteRequest = this.quoteRequest;
      result.quoteRequestStateToAccepted = this.quoteRequestStateToAccepted;
      result.quoteRequestVersion = this.quoteRequestVersion;
      result.custom = this.custom;
      result.state = this.state;
      return result;
    }

    public Builder key(String key) {
      this.key = key;
      return this;
    }

    public Builder quoteRequest(ResourceIdentifierInput quoteRequest) {
      this.quoteRequest = quoteRequest;
      return this;
    }

    public Builder quoteRequestStateToAccepted(Boolean quoteRequestStateToAccepted) {
      this.quoteRequestStateToAccepted = quoteRequestStateToAccepted;
      return this;
    }

    public Builder quoteRequestVersion(Long quoteRequestVersion) {
      this.quoteRequestVersion = quoteRequestVersion;
      return this;
    }

    public Builder custom(CustomFieldsDraft custom) {
      this.custom = custom;
      return this;
    }

    public Builder state(ReferenceInput state) {
      this.state = state;
      return this;
    }
  }
}
