package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class StagedQuoteSellerCommentSet implements com.commercetools.graphql.api.types.MessagePayload {
  private String sellerComment;

  private String type;

  public StagedQuoteSellerCommentSet() {
  }

  public StagedQuoteSellerCommentSet(String sellerComment, String type) {
    this.sellerComment = sellerComment;
    this.type = type;
  }

  public String getSellerComment() {
    return sellerComment;
  }

  public void setSellerComment(String sellerComment) {
    this.sellerComment = sellerComment;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "StagedQuoteSellerCommentSet{sellerComment='" + sellerComment + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    StagedQuoteSellerCommentSet that = (StagedQuoteSellerCommentSet) o;
    return Objects.equals(sellerComment, that.sellerComment) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(sellerComment, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String sellerComment;

    private String type;

    public StagedQuoteSellerCommentSet build() {
      StagedQuoteSellerCommentSet result = new StagedQuoteSellerCommentSet();
      result.sellerComment = this.sellerComment;
      result.type = this.type;
      return result;
    }

    public Builder sellerComment(String sellerComment) {
      this.sellerComment = sellerComment;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
