package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class StandalonePriceDeleted implements com.commercetools.graphql.api.types.MessagePayload {
  private String sku;

  private String type;

  public StandalonePriceDeleted() {
  }

  public StandalonePriceDeleted(String sku, String type) {
    this.sku = sku;
    this.type = type;
  }

  public String getSku() {
    return sku;
  }

  public void setSku(String sku) {
    this.sku = sku;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "StandalonePriceDeleted{sku='" + sku + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    StandalonePriceDeleted that = (StandalonePriceDeleted) o;
    return Objects.equals(sku, that.sku) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(sku, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String sku;

    private String type;

    public StandalonePriceDeleted build() {
      StandalonePriceDeleted result = new StandalonePriceDeleted();
      result.sku = this.sku;
      result.type = this.type;
      return result;
    }

    public Builder sku(String sku) {
      this.sku = sku;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
