package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class StandalonePriceDiscountSet implements com.commercetools.graphql.api.types.MessagePayload {
  private DiscountedProductPriceValue discounted;

  private String type;

  public StandalonePriceDiscountSet() {
  }

  public StandalonePriceDiscountSet(DiscountedProductPriceValue discounted, String type) {
    this.discounted = discounted;
    this.type = type;
  }

  public DiscountedProductPriceValue getDiscounted() {
    return discounted;
  }

  public void setDiscounted(DiscountedProductPriceValue discounted) {
    this.discounted = discounted;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "StandalonePriceDiscountSet{discounted='" + discounted + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    StandalonePriceDiscountSet that = (StandalonePriceDiscountSet) o;
    return Objects.equals(discounted, that.discounted) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(discounted, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private DiscountedProductPriceValue discounted;

    private String type;

    public StandalonePriceDiscountSet build() {
      StandalonePriceDiscountSet result = new StandalonePriceDiscountSet();
      result.discounted = this.discounted;
      result.type = this.type;
      return result;
    }

    public Builder discounted(DiscountedProductPriceValue discounted) {
      this.discounted = discounted;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
