package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class StandalonePriceKeySet implements com.commercetools.graphql.api.types.MessagePayload {
  private String key;

  private String oldKey;

  private String type;

  public StandalonePriceKeySet() {
  }

  public StandalonePriceKeySet(String key, String oldKey, String type) {
    this.key = key;
    this.oldKey = oldKey;
    this.type = type;
  }

  public String getKey() {
    return key;
  }

  public void setKey(String key) {
    this.key = key;
  }

  public String getOldKey() {
    return oldKey;
  }

  public void setOldKey(String oldKey) {
    this.oldKey = oldKey;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "StandalonePriceKeySet{key='" + key + "', oldKey='" + oldKey + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    StandalonePriceKeySet that = (StandalonePriceKeySet) o;
    return Objects.equals(key, that.key) &&
        Objects.equals(oldKey, that.oldKey) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(key, oldKey, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String key;

    private String oldKey;

    private String type;

    public StandalonePriceKeySet build() {
      StandalonePriceKeySet result = new StandalonePriceKeySet();
      result.key = this.key;
      result.oldKey = this.oldKey;
      result.type = this.type;
      return result;
    }

    public Builder key(String key) {
      this.key = key;
      return this;
    }

    public Builder oldKey(String oldKey) {
      this.oldKey = oldKey;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
