package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class StandalonePriceStagedChangesRemoved implements com.commercetools.graphql.api.types.MessagePayload {
  private StagedStandalonePrice stagedChanges;

  private String type;

  public StandalonePriceStagedChangesRemoved() {
  }

  public StandalonePriceStagedChangesRemoved(StagedStandalonePrice stagedChanges, String type) {
    this.stagedChanges = stagedChanges;
    this.type = type;
  }

  public StagedStandalonePrice getStagedChanges() {
    return stagedChanges;
  }

  public void setStagedChanges(StagedStandalonePrice stagedChanges) {
    this.stagedChanges = stagedChanges;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "StandalonePriceStagedChangesRemoved{stagedChanges='" + stagedChanges + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    StandalonePriceStagedChangesRemoved that = (StandalonePriceStagedChangesRemoved) o;
    return Objects.equals(stagedChanges, that.stagedChanges) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(stagedChanges, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private StagedStandalonePrice stagedChanges;

    private String type;

    public StandalonePriceStagedChangesRemoved build() {
      StandalonePriceStagedChangesRemoved result = new StandalonePriceStagedChangesRemoved();
      result.stagedChanges = this.stagedChanges;
      result.type = this.type;
      return result;
    }

    public Builder stagedChanges(StagedStandalonePrice stagedChanges) {
      this.stagedChanges = stagedChanges;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
