package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class StandalonePriceTiersSet implements com.commercetools.graphql.api.types.MessagePayload {
  private List<ProductPriceTier> tiers;

  private List<ProductPriceTier> previousTiers;

  private String type;

  public StandalonePriceTiersSet() {
  }

  public StandalonePriceTiersSet(List<ProductPriceTier> tiers, List<ProductPriceTier> previousTiers,
      String type) {
    this.tiers = tiers;
    this.previousTiers = previousTiers;
    this.type = type;
  }

  public List<ProductPriceTier> getTiers() {
    return tiers;
  }

  public void setTiers(List<ProductPriceTier> tiers) {
    this.tiers = tiers;
  }

  public List<ProductPriceTier> getPreviousTiers() {
    return previousTiers;
  }

  public void setPreviousTiers(List<ProductPriceTier> previousTiers) {
    this.previousTiers = previousTiers;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "StandalonePriceTiersSet{tiers='" + tiers + "', previousTiers='" + previousTiers + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    StandalonePriceTiersSet that = (StandalonePriceTiersSet) o;
    return Objects.equals(tiers, that.tiers) &&
        Objects.equals(previousTiers, that.previousTiers) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(tiers, previousTiers, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private List<ProductPriceTier> tiers;

    private List<ProductPriceTier> previousTiers;

    private String type;

    public StandalonePriceTiersSet build() {
      StandalonePriceTiersSet result = new StandalonePriceTiersSet();
      result.tiers = this.tiers;
      result.previousTiers = this.previousTiers;
      result.type = this.type;
      return result;
    }

    public Builder tiers(List<ProductPriceTier> tiers) {
      this.tiers = tiers;
      return this;
    }

    public Builder previousTiers(List<ProductPriceTier> previousTiers) {
      this.previousTiers = previousTiers;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
