package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class StandalonePriceUpdateAction {
  private ApplyStagedChanges applyStagedChanges;

  private ChangeStandalonePriceActive changeActive;

  private ChangeStandalonePriceValue changeValue;

  private SetStandalonePriceKey setKey;

  private SetStandalonePriceDiscountedPrice setDiscountedPrice;

  private SetStandalonePriceCustomFields setCustomField;

  private CustomFieldsDraft setCustomType;

  private SetStandalonePriceValidFromAndUntil setValidFromAndUntil;

  private SetStandalonePriceValidFrom setValidFrom;

  private SetStandalonePriceValidUntil setValidUntil;

  private AddStandalonePriceTier addPriceTier;

  private RemoveStandalonePriceTier removePriceTier;

  private RemoveStagedChanges removeStagedChanges;

  private SetStandalonePriceTiers setPriceTiers;

  public StandalonePriceUpdateAction() {
  }

  public StandalonePriceUpdateAction(ApplyStagedChanges applyStagedChanges,
      ChangeStandalonePriceActive changeActive, ChangeStandalonePriceValue changeValue,
      SetStandalonePriceKey setKey, SetStandalonePriceDiscountedPrice setDiscountedPrice,
      SetStandalonePriceCustomFields setCustomField, CustomFieldsDraft setCustomType,
      SetStandalonePriceValidFromAndUntil setValidFromAndUntil,
      SetStandalonePriceValidFrom setValidFrom, SetStandalonePriceValidUntil setValidUntil,
      AddStandalonePriceTier addPriceTier, RemoveStandalonePriceTier removePriceTier,
      RemoveStagedChanges removeStagedChanges, SetStandalonePriceTiers setPriceTiers) {
    this.applyStagedChanges = applyStagedChanges;
    this.changeActive = changeActive;
    this.changeValue = changeValue;
    this.setKey = setKey;
    this.setDiscountedPrice = setDiscountedPrice;
    this.setCustomField = setCustomField;
    this.setCustomType = setCustomType;
    this.setValidFromAndUntil = setValidFromAndUntil;
    this.setValidFrom = setValidFrom;
    this.setValidUntil = setValidUntil;
    this.addPriceTier = addPriceTier;
    this.removePriceTier = removePriceTier;
    this.removeStagedChanges = removeStagedChanges;
    this.setPriceTiers = setPriceTiers;
  }

  public ApplyStagedChanges getApplyStagedChanges() {
    return applyStagedChanges;
  }

  public void setApplyStagedChanges(ApplyStagedChanges applyStagedChanges) {
    this.applyStagedChanges = applyStagedChanges;
  }

  public ChangeStandalonePriceActive getChangeActive() {
    return changeActive;
  }

  public void setChangeActive(ChangeStandalonePriceActive changeActive) {
    this.changeActive = changeActive;
  }

  public ChangeStandalonePriceValue getChangeValue() {
    return changeValue;
  }

  public void setChangeValue(ChangeStandalonePriceValue changeValue) {
    this.changeValue = changeValue;
  }

  public SetStandalonePriceKey getSetKey() {
    return setKey;
  }

  public void setSetKey(SetStandalonePriceKey setKey) {
    this.setKey = setKey;
  }

  public SetStandalonePriceDiscountedPrice getSetDiscountedPrice() {
    return setDiscountedPrice;
  }

  public void setSetDiscountedPrice(SetStandalonePriceDiscountedPrice setDiscountedPrice) {
    this.setDiscountedPrice = setDiscountedPrice;
  }

  public SetStandalonePriceCustomFields getSetCustomField() {
    return setCustomField;
  }

  public void setSetCustomField(SetStandalonePriceCustomFields setCustomField) {
    this.setCustomField = setCustomField;
  }

  public CustomFieldsDraft getSetCustomType() {
    return setCustomType;
  }

  public void setSetCustomType(CustomFieldsDraft setCustomType) {
    this.setCustomType = setCustomType;
  }

  public SetStandalonePriceValidFromAndUntil getSetValidFromAndUntil() {
    return setValidFromAndUntil;
  }

  public void setSetValidFromAndUntil(SetStandalonePriceValidFromAndUntil setValidFromAndUntil) {
    this.setValidFromAndUntil = setValidFromAndUntil;
  }

  public SetStandalonePriceValidFrom getSetValidFrom() {
    return setValidFrom;
  }

  public void setSetValidFrom(SetStandalonePriceValidFrom setValidFrom) {
    this.setValidFrom = setValidFrom;
  }

  public SetStandalonePriceValidUntil getSetValidUntil() {
    return setValidUntil;
  }

  public void setSetValidUntil(SetStandalonePriceValidUntil setValidUntil) {
    this.setValidUntil = setValidUntil;
  }

  public AddStandalonePriceTier getAddPriceTier() {
    return addPriceTier;
  }

  public void setAddPriceTier(AddStandalonePriceTier addPriceTier) {
    this.addPriceTier = addPriceTier;
  }

  public RemoveStandalonePriceTier getRemovePriceTier() {
    return removePriceTier;
  }

  public void setRemovePriceTier(RemoveStandalonePriceTier removePriceTier) {
    this.removePriceTier = removePriceTier;
  }

  public RemoveStagedChanges getRemoveStagedChanges() {
    return removeStagedChanges;
  }

  public void setRemoveStagedChanges(RemoveStagedChanges removeStagedChanges) {
    this.removeStagedChanges = removeStagedChanges;
  }

  public SetStandalonePriceTiers getSetPriceTiers() {
    return setPriceTiers;
  }

  public void setSetPriceTiers(SetStandalonePriceTiers setPriceTiers) {
    this.setPriceTiers = setPriceTiers;
  }

  @Override
  public String toString() {
    return "StandalonePriceUpdateAction{applyStagedChanges='" + applyStagedChanges + "', changeActive='" + changeActive + "', changeValue='" + changeValue + "', setKey='" + setKey + "', setDiscountedPrice='" + setDiscountedPrice + "', setCustomField='" + setCustomField + "', setCustomType='" + setCustomType + "', setValidFromAndUntil='" + setValidFromAndUntil + "', setValidFrom='" + setValidFrom + "', setValidUntil='" + setValidUntil + "', addPriceTier='" + addPriceTier + "', removePriceTier='" + removePriceTier + "', removeStagedChanges='" + removeStagedChanges + "', setPriceTiers='" + setPriceTiers + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    StandalonePriceUpdateAction that = (StandalonePriceUpdateAction) o;
    return Objects.equals(applyStagedChanges, that.applyStagedChanges) &&
        Objects.equals(changeActive, that.changeActive) &&
        Objects.equals(changeValue, that.changeValue) &&
        Objects.equals(setKey, that.setKey) &&
        Objects.equals(setDiscountedPrice, that.setDiscountedPrice) &&
        Objects.equals(setCustomField, that.setCustomField) &&
        Objects.equals(setCustomType, that.setCustomType) &&
        Objects.equals(setValidFromAndUntil, that.setValidFromAndUntil) &&
        Objects.equals(setValidFrom, that.setValidFrom) &&
        Objects.equals(setValidUntil, that.setValidUntil) &&
        Objects.equals(addPriceTier, that.addPriceTier) &&
        Objects.equals(removePriceTier, that.removePriceTier) &&
        Objects.equals(removeStagedChanges, that.removeStagedChanges) &&
        Objects.equals(setPriceTiers, that.setPriceTiers);
  }

  @Override
  public int hashCode() {
    return Objects.hash(applyStagedChanges, changeActive, changeValue, setKey, setDiscountedPrice, setCustomField, setCustomType, setValidFromAndUntil, setValidFrom, setValidUntil, addPriceTier, removePriceTier, removeStagedChanges, setPriceTiers);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private ApplyStagedChanges applyStagedChanges;

    private ChangeStandalonePriceActive changeActive;

    private ChangeStandalonePriceValue changeValue;

    private SetStandalonePriceKey setKey;

    private SetStandalonePriceDiscountedPrice setDiscountedPrice;

    private SetStandalonePriceCustomFields setCustomField;

    private CustomFieldsDraft setCustomType;

    private SetStandalonePriceValidFromAndUntil setValidFromAndUntil;

    private SetStandalonePriceValidFrom setValidFrom;

    private SetStandalonePriceValidUntil setValidUntil;

    private AddStandalonePriceTier addPriceTier;

    private RemoveStandalonePriceTier removePriceTier;

    private RemoveStagedChanges removeStagedChanges;

    private SetStandalonePriceTiers setPriceTiers;

    public StandalonePriceUpdateAction build() {
      StandalonePriceUpdateAction result = new StandalonePriceUpdateAction();
      result.applyStagedChanges = this.applyStagedChanges;
      result.changeActive = this.changeActive;
      result.changeValue = this.changeValue;
      result.setKey = this.setKey;
      result.setDiscountedPrice = this.setDiscountedPrice;
      result.setCustomField = this.setCustomField;
      result.setCustomType = this.setCustomType;
      result.setValidFromAndUntil = this.setValidFromAndUntil;
      result.setValidFrom = this.setValidFrom;
      result.setValidUntil = this.setValidUntil;
      result.addPriceTier = this.addPriceTier;
      result.removePriceTier = this.removePriceTier;
      result.removeStagedChanges = this.removeStagedChanges;
      result.setPriceTiers = this.setPriceTiers;
      return result;
    }

    public Builder applyStagedChanges(ApplyStagedChanges applyStagedChanges) {
      this.applyStagedChanges = applyStagedChanges;
      return this;
    }

    public Builder changeActive(ChangeStandalonePriceActive changeActive) {
      this.changeActive = changeActive;
      return this;
    }

    public Builder changeValue(ChangeStandalonePriceValue changeValue) {
      this.changeValue = changeValue;
      return this;
    }

    public Builder setKey(SetStandalonePriceKey setKey) {
      this.setKey = setKey;
      return this;
    }

    public Builder setDiscountedPrice(SetStandalonePriceDiscountedPrice setDiscountedPrice) {
      this.setDiscountedPrice = setDiscountedPrice;
      return this;
    }

    public Builder setCustomField(SetStandalonePriceCustomFields setCustomField) {
      this.setCustomField = setCustomField;
      return this;
    }

    public Builder setCustomType(CustomFieldsDraft setCustomType) {
      this.setCustomType = setCustomType;
      return this;
    }

    public Builder setValidFromAndUntil(SetStandalonePriceValidFromAndUntil setValidFromAndUntil) {
      this.setValidFromAndUntil = setValidFromAndUntil;
      return this;
    }

    public Builder setValidFrom(SetStandalonePriceValidFrom setValidFrom) {
      this.setValidFrom = setValidFrom;
      return this;
    }

    public Builder setValidUntil(SetStandalonePriceValidUntil setValidUntil) {
      this.setValidUntil = setValidUntil;
      return this;
    }

    public Builder addPriceTier(AddStandalonePriceTier addPriceTier) {
      this.addPriceTier = addPriceTier;
      return this;
    }

    public Builder removePriceTier(RemoveStandalonePriceTier removePriceTier) {
      this.removePriceTier = removePriceTier;
      return this;
    }

    public Builder removeStagedChanges(RemoveStagedChanges removeStagedChanges) {
      this.removeStagedChanges = removeStagedChanges;
      return this;
    }

    public Builder setPriceTiers(SetStandalonePriceTiers setPriceTiers) {
      this.setPriceTiers = setPriceTiers;
      return this;
    }
  }
}
