package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.time.OffsetDateTime;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class StandalonePriceValidFromSet implements com.commercetools.graphql.api.types.MessagePayload {
  private OffsetDateTime validFrom;

  private OffsetDateTime previousValidFrom;

  private String type;

  public StandalonePriceValidFromSet() {
  }

  public StandalonePriceValidFromSet(OffsetDateTime validFrom, OffsetDateTime previousValidFrom,
      String type) {
    this.validFrom = validFrom;
    this.previousValidFrom = previousValidFrom;
    this.type = type;
  }

  public OffsetDateTime getValidFrom() {
    return validFrom;
  }

  public void setValidFrom(OffsetDateTime validFrom) {
    this.validFrom = validFrom;
  }

  public OffsetDateTime getPreviousValidFrom() {
    return previousValidFrom;
  }

  public void setPreviousValidFrom(OffsetDateTime previousValidFrom) {
    this.previousValidFrom = previousValidFrom;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "StandalonePriceValidFromSet{validFrom='" + validFrom + "', previousValidFrom='" + previousValidFrom + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    StandalonePriceValidFromSet that = (StandalonePriceValidFromSet) o;
    return Objects.equals(validFrom, that.validFrom) &&
        Objects.equals(previousValidFrom, that.previousValidFrom) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(validFrom, previousValidFrom, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private OffsetDateTime validFrom;

    private OffsetDateTime previousValidFrom;

    private String type;

    public StandalonePriceValidFromSet build() {
      StandalonePriceValidFromSet result = new StandalonePriceValidFromSet();
      result.validFrom = this.validFrom;
      result.previousValidFrom = this.previousValidFrom;
      result.type = this.type;
      return result;
    }

    public Builder validFrom(OffsetDateTime validFrom) {
      this.validFrom = validFrom;
      return this;
    }

    public Builder previousValidFrom(OffsetDateTime previousValidFrom) {
      this.previousValidFrom = previousValidFrom;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
