package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Objects;

/**
 * Stores allow defining different contexts for a project.
 */
@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class Store implements com.commercetools.graphql.api.types.Versioned, com.commercetools.graphql.api.types.ReferenceExpandable {
  private String id;

  private Long version;

  private String key;

  private String name;

  private List<LocalizedString> nameAllLocales;

  private List<String> languages;

  private List<StoreCountry> countries;

  private List<ProductSelectionSetting> productSelections;

  private List<Reference> distributionChannelsRef;

  private List<Channel> distributionChannels;

  private List<Reference> supplyChannelsRef;

  private List<Channel> supplyChannels;

  private OffsetDateTime createdAt;

  private OffsetDateTime lastModifiedAt;

  private CustomFieldsType custom;

  private Initiator createdBy;

  private Initiator lastModifiedBy;

  public Store() {
  }

  public Store(String id, Long version, String key, String name,
      List<LocalizedString> nameAllLocales, List<String> languages, List<StoreCountry> countries,
      List<ProductSelectionSetting> productSelections, List<Reference> distributionChannelsRef,
      List<Channel> distributionChannels, List<Reference> supplyChannelsRef,
      List<Channel> supplyChannels, OffsetDateTime createdAt, OffsetDateTime lastModifiedAt,
      CustomFieldsType custom, Initiator createdBy, Initiator lastModifiedBy) {
    this.id = id;
    this.version = version;
    this.key = key;
    this.name = name;
    this.nameAllLocales = nameAllLocales;
    this.languages = languages;
    this.countries = countries;
    this.productSelections = productSelections;
    this.distributionChannelsRef = distributionChannelsRef;
    this.distributionChannels = distributionChannels;
    this.supplyChannelsRef = supplyChannelsRef;
    this.supplyChannels = supplyChannels;
    this.createdAt = createdAt;
    this.lastModifiedAt = lastModifiedAt;
    this.custom = custom;
    this.createdBy = createdBy;
    this.lastModifiedBy = lastModifiedBy;
  }

  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }

  public Long getVersion() {
    return version;
  }

  public void setVersion(Long version) {
    this.version = version;
  }

  public String getKey() {
    return key;
  }

  public void setKey(String key) {
    this.key = key;
  }

  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public List<LocalizedString> getNameAllLocales() {
    return nameAllLocales;
  }

  public void setNameAllLocales(List<LocalizedString> nameAllLocales) {
    this.nameAllLocales = nameAllLocales;
  }

  public List<String> getLanguages() {
    return languages;
  }

  public void setLanguages(List<String> languages) {
    this.languages = languages;
  }

  public List<StoreCountry> getCountries() {
    return countries;
  }

  public void setCountries(List<StoreCountry> countries) {
    this.countries = countries;
  }

  public List<ProductSelectionSetting> getProductSelections() {
    return productSelections;
  }

  public void setProductSelections(List<ProductSelectionSetting> productSelections) {
    this.productSelections = productSelections;
  }

  public List<Reference> getDistributionChannelsRef() {
    return distributionChannelsRef;
  }

  public void setDistributionChannelsRef(List<Reference> distributionChannelsRef) {
    this.distributionChannelsRef = distributionChannelsRef;
  }

  public List<Channel> getDistributionChannels() {
    return distributionChannels;
  }

  public void setDistributionChannels(List<Channel> distributionChannels) {
    this.distributionChannels = distributionChannels;
  }

  public List<Reference> getSupplyChannelsRef() {
    return supplyChannelsRef;
  }

  public void setSupplyChannelsRef(List<Reference> supplyChannelsRef) {
    this.supplyChannelsRef = supplyChannelsRef;
  }

  public List<Channel> getSupplyChannels() {
    return supplyChannels;
  }

  public void setSupplyChannels(List<Channel> supplyChannels) {
    this.supplyChannels = supplyChannels;
  }

  public OffsetDateTime getCreatedAt() {
    return createdAt;
  }

  public void setCreatedAt(OffsetDateTime createdAt) {
    this.createdAt = createdAt;
  }

  public OffsetDateTime getLastModifiedAt() {
    return lastModifiedAt;
  }

  public void setLastModifiedAt(OffsetDateTime lastModifiedAt) {
    this.lastModifiedAt = lastModifiedAt;
  }

  public CustomFieldsType getCustom() {
    return custom;
  }

  public void setCustom(CustomFieldsType custom) {
    this.custom = custom;
  }

  public Initiator getCreatedBy() {
    return createdBy;
  }

  public void setCreatedBy(Initiator createdBy) {
    this.createdBy = createdBy;
  }

  public Initiator getLastModifiedBy() {
    return lastModifiedBy;
  }

  public void setLastModifiedBy(Initiator lastModifiedBy) {
    this.lastModifiedBy = lastModifiedBy;
  }

  @Override
  public String toString() {
    return "Store{id='" + id + "', version='" + version + "', key='" + key + "', name='" + name + "', nameAllLocales='" + nameAllLocales + "', languages='" + languages + "', countries='" + countries + "', productSelections='" + productSelections + "', distributionChannelsRef='" + distributionChannelsRef + "', distributionChannels='" + distributionChannels + "', supplyChannelsRef='" + supplyChannelsRef + "', supplyChannels='" + supplyChannels + "', createdAt='" + createdAt + "', lastModifiedAt='" + lastModifiedAt + "', custom='" + custom + "', createdBy='" + createdBy + "', lastModifiedBy='" + lastModifiedBy + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    Store that = (Store) o;
    return Objects.equals(id, that.id) &&
        Objects.equals(version, that.version) &&
        Objects.equals(key, that.key) &&
        Objects.equals(name, that.name) &&
        Objects.equals(nameAllLocales, that.nameAllLocales) &&
        Objects.equals(languages, that.languages) &&
        Objects.equals(countries, that.countries) &&
        Objects.equals(productSelections, that.productSelections) &&
        Objects.equals(distributionChannelsRef, that.distributionChannelsRef) &&
        Objects.equals(distributionChannels, that.distributionChannels) &&
        Objects.equals(supplyChannelsRef, that.supplyChannelsRef) &&
        Objects.equals(supplyChannels, that.supplyChannels) &&
        Objects.equals(createdAt, that.createdAt) &&
        Objects.equals(lastModifiedAt, that.lastModifiedAt) &&
        Objects.equals(custom, that.custom) &&
        Objects.equals(createdBy, that.createdBy) &&
        Objects.equals(lastModifiedBy, that.lastModifiedBy);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, version, key, name, nameAllLocales, languages, countries, productSelections, distributionChannelsRef, distributionChannels, supplyChannelsRef, supplyChannels, createdAt, lastModifiedAt, custom, createdBy, lastModifiedBy);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String id;

    private Long version;

    private String key;

    private String name;

    private List<LocalizedString> nameAllLocales;

    private List<String> languages;

    private List<StoreCountry> countries;

    private List<ProductSelectionSetting> productSelections;

    private List<Reference> distributionChannelsRef;

    private List<Channel> distributionChannels;

    private List<Reference> supplyChannelsRef;

    private List<Channel> supplyChannels;

    private OffsetDateTime createdAt;

    private OffsetDateTime lastModifiedAt;

    private CustomFieldsType custom;

    private Initiator createdBy;

    private Initiator lastModifiedBy;

    public Store build() {
      Store result = new Store();
      result.id = this.id;
      result.version = this.version;
      result.key = this.key;
      result.name = this.name;
      result.nameAllLocales = this.nameAllLocales;
      result.languages = this.languages;
      result.countries = this.countries;
      result.productSelections = this.productSelections;
      result.distributionChannelsRef = this.distributionChannelsRef;
      result.distributionChannels = this.distributionChannels;
      result.supplyChannelsRef = this.supplyChannelsRef;
      result.supplyChannels = this.supplyChannels;
      result.createdAt = this.createdAt;
      result.lastModifiedAt = this.lastModifiedAt;
      result.custom = this.custom;
      result.createdBy = this.createdBy;
      result.lastModifiedBy = this.lastModifiedBy;
      return result;
    }

    public Builder id(String id) {
      this.id = id;
      return this;
    }

    public Builder version(Long version) {
      this.version = version;
      return this;
    }

    public Builder key(String key) {
      this.key = key;
      return this;
    }

    public Builder name(String name) {
      this.name = name;
      return this;
    }

    public Builder nameAllLocales(List<LocalizedString> nameAllLocales) {
      this.nameAllLocales = nameAllLocales;
      return this;
    }

    public Builder languages(List<String> languages) {
      this.languages = languages;
      return this;
    }

    public Builder countries(List<StoreCountry> countries) {
      this.countries = countries;
      return this;
    }

    public Builder productSelections(List<ProductSelectionSetting> productSelections) {
      this.productSelections = productSelections;
      return this;
    }

    public Builder distributionChannelsRef(List<Reference> distributionChannelsRef) {
      this.distributionChannelsRef = distributionChannelsRef;
      return this;
    }

    public Builder distributionChannels(List<Channel> distributionChannels) {
      this.distributionChannels = distributionChannels;
      return this;
    }

    public Builder supplyChannelsRef(List<Reference> supplyChannelsRef) {
      this.supplyChannelsRef = supplyChannelsRef;
      return this;
    }

    public Builder supplyChannels(List<Channel> supplyChannels) {
      this.supplyChannels = supplyChannels;
      return this;
    }

    public Builder createdAt(OffsetDateTime createdAt) {
      this.createdAt = createdAt;
      return this;
    }

    public Builder lastModifiedAt(OffsetDateTime lastModifiedAt) {
      this.lastModifiedAt = lastModifiedAt;
      return this;
    }

    public Builder custom(CustomFieldsType custom) {
      this.custom = custom;
      return this;
    }

    public Builder createdBy(Initiator createdBy) {
      this.createdBy = createdBy;
      return this;
    }

    public Builder lastModifiedBy(Initiator lastModifiedBy) {
      this.lastModifiedBy = lastModifiedBy;
      return this;
    }
  }
}
