package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class StoreNameSet implements com.commercetools.graphql.api.types.MessagePayload {
  private String name;

  private List<LocalizedString> nameAllLocales;

  private String type;

  public StoreNameSet() {
  }

  public StoreNameSet(String name, List<LocalizedString> nameAllLocales, String type) {
    this.name = name;
    this.nameAllLocales = nameAllLocales;
    this.type = type;
  }

  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public List<LocalizedString> getNameAllLocales() {
    return nameAllLocales;
  }

  public void setNameAllLocales(List<LocalizedString> nameAllLocales) {
    this.nameAllLocales = nameAllLocales;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "StoreNameSet{name='" + name + "', nameAllLocales='" + nameAllLocales + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    StoreNameSet that = (StoreNameSet) o;
    return Objects.equals(name, that.name) &&
        Objects.equals(nameAllLocales, that.nameAllLocales) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(name, nameAllLocales, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String name;

    private List<LocalizedString> nameAllLocales;

    private String type;

    public StoreNameSet build() {
      StoreNameSet result = new StoreNameSet();
      result.name = this.name;
      result.nameAllLocales = this.nameAllLocales;
      result.type = this.type;
      return result;
    }

    public Builder name(String name) {
      this.name = name;
      return this;
    }

    public Builder nameAllLocales(List<LocalizedString> nameAllLocales) {
      this.nameAllLocales = nameAllLocales;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
