package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class StoreProductSelectionsChanged implements com.commercetools.graphql.api.types.MessagePayload {
  private List<ProductSelectionSetting> addedProductSelections;

  private List<ProductSelectionSetting> removedProductSelections;

  private List<ProductSelectionSetting> updatedProductSelections;

  private String type;

  public StoreProductSelectionsChanged() {
  }

  public StoreProductSelectionsChanged(List<ProductSelectionSetting> addedProductSelections,
      List<ProductSelectionSetting> removedProductSelections,
      List<ProductSelectionSetting> updatedProductSelections, String type) {
    this.addedProductSelections = addedProductSelections;
    this.removedProductSelections = removedProductSelections;
    this.updatedProductSelections = updatedProductSelections;
    this.type = type;
  }

  public List<ProductSelectionSetting> getAddedProductSelections() {
    return addedProductSelections;
  }

  public void setAddedProductSelections(List<ProductSelectionSetting> addedProductSelections) {
    this.addedProductSelections = addedProductSelections;
  }

  public List<ProductSelectionSetting> getRemovedProductSelections() {
    return removedProductSelections;
  }

  public void setRemovedProductSelections(List<ProductSelectionSetting> removedProductSelections) {
    this.removedProductSelections = removedProductSelections;
  }

  public List<ProductSelectionSetting> getUpdatedProductSelections() {
    return updatedProductSelections;
  }

  public void setUpdatedProductSelections(List<ProductSelectionSetting> updatedProductSelections) {
    this.updatedProductSelections = updatedProductSelections;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "StoreProductSelectionsChanged{addedProductSelections='" + addedProductSelections + "', removedProductSelections='" + removedProductSelections + "', updatedProductSelections='" + updatedProductSelections + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    StoreProductSelectionsChanged that = (StoreProductSelectionsChanged) o;
    return Objects.equals(addedProductSelections, that.addedProductSelections) &&
        Objects.equals(removedProductSelections, that.removedProductSelections) &&
        Objects.equals(updatedProductSelections, that.updatedProductSelections) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(addedProductSelections, removedProductSelections, updatedProductSelections, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private List<ProductSelectionSetting> addedProductSelections;

    private List<ProductSelectionSetting> removedProductSelections;

    private List<ProductSelectionSetting> updatedProductSelections;

    private String type;

    public StoreProductSelectionsChanged build() {
      StoreProductSelectionsChanged result = new StoreProductSelectionsChanged();
      result.addedProductSelections = this.addedProductSelections;
      result.removedProductSelections = this.removedProductSelections;
      result.updatedProductSelections = this.updatedProductSelections;
      result.type = this.type;
      return result;
    }

    public Builder addedProductSelections(List<ProductSelectionSetting> addedProductSelections) {
      this.addedProductSelections = addedProductSelections;
      return this;
    }

    public Builder removedProductSelections(
        List<ProductSelectionSetting> removedProductSelections) {
      this.removedProductSelections = removedProductSelections;
      return this;
    }

    public Builder updatedProductSelections(
        List<ProductSelectionSetting> updatedProductSelections) {
      this.updatedProductSelections = updatedProductSelections;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
