package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class StoreSupplyChannelsChanged implements com.commercetools.graphql.api.types.MessagePayload {
  private List<Channel> addedSupplyChannels;

  private List<Channel> removedSupplyChannels;

  private List<Reference> addedSupplyChannelsRef;

  private List<Reference> removedSupplyChannelsRef;

  private String type;

  public StoreSupplyChannelsChanged() {
  }

  public StoreSupplyChannelsChanged(List<Channel> addedSupplyChannels,
      List<Channel> removedSupplyChannels, List<Reference> addedSupplyChannelsRef,
      List<Reference> removedSupplyChannelsRef, String type) {
    this.addedSupplyChannels = addedSupplyChannels;
    this.removedSupplyChannels = removedSupplyChannels;
    this.addedSupplyChannelsRef = addedSupplyChannelsRef;
    this.removedSupplyChannelsRef = removedSupplyChannelsRef;
    this.type = type;
  }

  public List<Channel> getAddedSupplyChannels() {
    return addedSupplyChannels;
  }

  public void setAddedSupplyChannels(List<Channel> addedSupplyChannels) {
    this.addedSupplyChannels = addedSupplyChannels;
  }

  public List<Channel> getRemovedSupplyChannels() {
    return removedSupplyChannels;
  }

  public void setRemovedSupplyChannels(List<Channel> removedSupplyChannels) {
    this.removedSupplyChannels = removedSupplyChannels;
  }

  public List<Reference> getAddedSupplyChannelsRef() {
    return addedSupplyChannelsRef;
  }

  public void setAddedSupplyChannelsRef(List<Reference> addedSupplyChannelsRef) {
    this.addedSupplyChannelsRef = addedSupplyChannelsRef;
  }

  public List<Reference> getRemovedSupplyChannelsRef() {
    return removedSupplyChannelsRef;
  }

  public void setRemovedSupplyChannelsRef(List<Reference> removedSupplyChannelsRef) {
    this.removedSupplyChannelsRef = removedSupplyChannelsRef;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "StoreSupplyChannelsChanged{addedSupplyChannels='" + addedSupplyChannels + "', removedSupplyChannels='" + removedSupplyChannels + "', addedSupplyChannelsRef='" + addedSupplyChannelsRef + "', removedSupplyChannelsRef='" + removedSupplyChannelsRef + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    StoreSupplyChannelsChanged that = (StoreSupplyChannelsChanged) o;
    return Objects.equals(addedSupplyChannels, that.addedSupplyChannels) &&
        Objects.equals(removedSupplyChannels, that.removedSupplyChannels) &&
        Objects.equals(addedSupplyChannelsRef, that.addedSupplyChannelsRef) &&
        Objects.equals(removedSupplyChannelsRef, that.removedSupplyChannelsRef) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(addedSupplyChannels, removedSupplyChannels, addedSupplyChannelsRef, removedSupplyChannelsRef, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private List<Channel> addedSupplyChannels;

    private List<Channel> removedSupplyChannels;

    private List<Reference> addedSupplyChannelsRef;

    private List<Reference> removedSupplyChannelsRef;

    private String type;

    public StoreSupplyChannelsChanged build() {
      StoreSupplyChannelsChanged result = new StoreSupplyChannelsChanged();
      result.addedSupplyChannels = this.addedSupplyChannels;
      result.removedSupplyChannels = this.removedSupplyChannels;
      result.addedSupplyChannelsRef = this.addedSupplyChannelsRef;
      result.removedSupplyChannelsRef = this.removedSupplyChannelsRef;
      result.type = this.type;
      return result;
    }

    public Builder addedSupplyChannels(List<Channel> addedSupplyChannels) {
      this.addedSupplyChannels = addedSupplyChannels;
      return this;
    }

    public Builder removedSupplyChannels(List<Channel> removedSupplyChannels) {
      this.removedSupplyChannels = removedSupplyChannels;
      return this;
    }

    public Builder addedSupplyChannelsRef(List<Reference> addedSupplyChannelsRef) {
      this.addedSupplyChannelsRef = addedSupplyChannelsRef;
      return this;
    }

    public Builder removedSupplyChannelsRef(List<Reference> removedSupplyChannelsRef) {
      this.removedSupplyChannelsRef = removedSupplyChannelsRef;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
