package com.commercetools.graphql.api.types;

import java.lang.Double;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class SubRateDraft {
  private String name;

  private Double amount;

  public SubRateDraft() {
  }

  public SubRateDraft(String name, Double amount) {
    this.name = name;
    this.amount = amount;
  }

  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public Double getAmount() {
    return amount;
  }

  public void setAmount(Double amount) {
    this.amount = amount;
  }

  @Override
  public String toString() {
    return "SubRateDraft{name='" + name + "', amount='" + amount + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SubRateDraft that = (SubRateDraft) o;
    return Objects.equals(name, that.name) &&
        Objects.equals(amount, that.amount);
  }

  @Override
  public int hashCode() {
    return Objects.hash(name, amount);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String name;

    private Double amount;

    public SubRateDraft build() {
      SubRateDraft result = new SubRateDraft();
      result.name = this.name;
      result.amount = this.amount;
      return result;
    }

    public Builder name(String name) {
      this.name = name;
      return this;
    }

    public Builder amount(Double amount) {
      this.amount = amount;
      return this;
    }
  }
}
