package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class SubscriptionFormatInput {
  private PlatformFormatInput Platform;

  private CloudEventsSubscriptionsFormatInput CloudEvents;

  public SubscriptionFormatInput() {
  }

  public SubscriptionFormatInput(PlatformFormatInput Platform,
      CloudEventsSubscriptionsFormatInput CloudEvents) {
    this.Platform = Platform;
    this.CloudEvents = CloudEvents;
  }

  public PlatformFormatInput getPlatform() {
    return Platform;
  }

  public void setPlatform(PlatformFormatInput Platform) {
    this.Platform = Platform;
  }

  public CloudEventsSubscriptionsFormatInput getCloudEvents() {
    return CloudEvents;
  }

  public void setCloudEvents(CloudEventsSubscriptionsFormatInput CloudEvents) {
    this.CloudEvents = CloudEvents;
  }

  @Override
  public String toString() {
    return "SubscriptionFormatInput{Platform='" + Platform + "', CloudEvents='" + CloudEvents + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SubscriptionFormatInput that = (SubscriptionFormatInput) o;
    return Objects.equals(Platform, that.Platform) &&
        Objects.equals(CloudEvents, that.CloudEvents);
  }

  @Override
  public int hashCode() {
    return Objects.hash(Platform, CloudEvents);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private PlatformFormatInput Platform;

    private CloudEventsSubscriptionsFormatInput CloudEvents;

    public SubscriptionFormatInput build() {
      SubscriptionFormatInput result = new SubscriptionFormatInput();
      result.Platform = this.Platform;
      result.CloudEvents = this.CloudEvents;
      return result;
    }

    public Builder Platform(PlatformFormatInput Platform) {
      this.Platform = Platform;
      return this;
    }

    public Builder CloudEvents(CloudEventsSubscriptionsFormatInput CloudEvents) {
      this.CloudEvents = CloudEvents;
      return this;
    }
  }
}
