package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class SubscriptionUpdateAction {
  private ChangeSubscriptionDestination changeDestination;

  private SetSubscriptionChanges setChanges;

  private SetSubscriptionKey setKey;

  private SetSubscriptionMessages setMessages;

  public SubscriptionUpdateAction() {
  }

  public SubscriptionUpdateAction(ChangeSubscriptionDestination changeDestination,
      SetSubscriptionChanges setChanges, SetSubscriptionKey setKey,
      SetSubscriptionMessages setMessages) {
    this.changeDestination = changeDestination;
    this.setChanges = setChanges;
    this.setKey = setKey;
    this.setMessages = setMessages;
  }

  public ChangeSubscriptionDestination getChangeDestination() {
    return changeDestination;
  }

  public void setChangeDestination(ChangeSubscriptionDestination changeDestination) {
    this.changeDestination = changeDestination;
  }

  public SetSubscriptionChanges getSetChanges() {
    return setChanges;
  }

  public void setSetChanges(SetSubscriptionChanges setChanges) {
    this.setChanges = setChanges;
  }

  public SetSubscriptionKey getSetKey() {
    return setKey;
  }

  public void setSetKey(SetSubscriptionKey setKey) {
    this.setKey = setKey;
  }

  public SetSubscriptionMessages getSetMessages() {
    return setMessages;
  }

  public void setSetMessages(SetSubscriptionMessages setMessages) {
    this.setMessages = setMessages;
  }

  @Override
  public String toString() {
    return "SubscriptionUpdateAction{changeDestination='" + changeDestination + "', setChanges='" + setChanges + "', setKey='" + setKey + "', setMessages='" + setMessages + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SubscriptionUpdateAction that = (SubscriptionUpdateAction) o;
    return Objects.equals(changeDestination, that.changeDestination) &&
        Objects.equals(setChanges, that.setChanges) &&
        Objects.equals(setKey, that.setKey) &&
        Objects.equals(setMessages, that.setMessages);
  }

  @Override
  public int hashCode() {
    return Objects.hash(changeDestination, setChanges, setKey, setMessages);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private ChangeSubscriptionDestination changeDestination;

    private SetSubscriptionChanges setChanges;

    private SetSubscriptionKey setKey;

    private SetSubscriptionMessages setMessages;

    public SubscriptionUpdateAction build() {
      SubscriptionUpdateAction result = new SubscriptionUpdateAction();
      result.changeDestination = this.changeDestination;
      result.setChanges = this.setChanges;
      result.setKey = this.setKey;
      result.setMessages = this.setMessages;
      return result;
    }

    public Builder changeDestination(ChangeSubscriptionDestination changeDestination) {
      this.changeDestination = changeDestination;
      return this;
    }

    public Builder setChanges(SetSubscriptionChanges setChanges) {
      this.setChanges = setChanges;
      return this;
    }

    public Builder setKey(SetSubscriptionKey setKey) {
      this.setKey = setKey;
      return this;
    }

    public Builder setMessages(SetSubscriptionMessages setMessages) {
      this.setMessages = setMessages;
      return this;
    }
  }
}
