package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class SubscriptionsLimitsProjection {
  private Limit maxSubscriptions;

  public SubscriptionsLimitsProjection() {
  }

  public SubscriptionsLimitsProjection(Limit maxSubscriptions) {
    this.maxSubscriptions = maxSubscriptions;
  }

  public Limit getMaxSubscriptions() {
    return maxSubscriptions;
  }

  public void setMaxSubscriptions(Limit maxSubscriptions) {
    this.maxSubscriptions = maxSubscriptions;
  }

  @Override
  public String toString() {
    return "SubscriptionsLimitsProjection{maxSubscriptions='" + maxSubscriptions + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SubscriptionsLimitsProjection that = (SubscriptionsLimitsProjection) o;
    return Objects.equals(maxSubscriptions, that.maxSubscriptions);
  }

  @Override
  public int hashCode() {
    return Objects.hash(maxSubscriptions);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private Limit maxSubscriptions;

    public SubscriptionsLimitsProjection build() {
      SubscriptionsLimitsProjection result = new SubscriptionsLimitsProjection();
      result.maxSubscriptions = this.maxSubscriptions;
      return result;
    }

    public Builder maxSubscriptions(Limit maxSubscriptions) {
      this.maxSubscriptions = maxSubscriptions;
      return this;
    }
  }
}
