package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.String;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NAME,
    include = JsonTypeInfo.As.PROPERTY,
    property = "__typename"
)
@JsonSubTypes({
    @JsonSubTypes.Type(value = CustomSuggestTokenizerProductSearch.class, name = "CustomSuggestTokenizerProductSearch"),
    @JsonSubTypes.Type(value = WhitespaceSuggestTokenizerProductSearch.class, name = "WhitespaceSuggestTokenizerProductSearch")
})
public interface SuggestTokenizerProductSearch {
  String getType();

  void setType(String type);
}
