package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class Suggestion {
  private String text;

  public Suggestion() {
  }

  public Suggestion(String text) {
    this.text = text;
  }

  public String getText() {
    return text;
  }

  public void setText(String text) {
    this.text = text;
  }

  @Override
  public String toString() {
    return "Suggestion{text='" + text + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    Suggestion that = (Suggestion) o;
    return Objects.equals(text, that.text);
  }

  @Override
  public int hashCode() {
    return Objects.hash(text);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String text;

    public Suggestion build() {
      Suggestion result = new Suggestion();
      result.text = this.text;
      return result;
    }

    public Builder text(String text) {
      this.text = text;
      return this;
    }
  }
}
