package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.time.OffsetDateTime;
import java.util.Objects;

/**
 * Stores information about order synchronization activities (like export or import).
 */
public class SyncInfo {
  private Reference channelRef;

  private Channel channel;

  private String externalId;

  private OffsetDateTime syncedAt;

  public SyncInfo() {
  }

  public SyncInfo(Reference channelRef, Channel channel, String externalId,
      OffsetDateTime syncedAt) {
    this.channelRef = channelRef;
    this.channel = channel;
    this.externalId = externalId;
    this.syncedAt = syncedAt;
  }

  public Reference getChannelRef() {
    return channelRef;
  }

  public void setChannelRef(Reference channelRef) {
    this.channelRef = channelRef;
  }

  public Channel getChannel() {
    return channel;
  }

  public void setChannel(Channel channel) {
    this.channel = channel;
  }

  public String getExternalId() {
    return externalId;
  }

  public void setExternalId(String externalId) {
    this.externalId = externalId;
  }

  public OffsetDateTime getSyncedAt() {
    return syncedAt;
  }

  public void setSyncedAt(OffsetDateTime syncedAt) {
    this.syncedAt = syncedAt;
  }

  @Override
  public String toString() {
    return "SyncInfo{channelRef='" + channelRef + "', channel='" + channel + "', externalId='" + externalId + "', syncedAt='" + syncedAt + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SyncInfo that = (SyncInfo) o;
    return Objects.equals(channelRef, that.channelRef) &&
        Objects.equals(channel, that.channel) &&
        Objects.equals(externalId, that.externalId) &&
        Objects.equals(syncedAt, that.syncedAt);
  }

  @Override
  public int hashCode() {
    return Objects.hash(channelRef, channel, externalId, syncedAt);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private Reference channelRef;

    private Channel channel;

    private String externalId;

    private OffsetDateTime syncedAt;

    public SyncInfo build() {
      SyncInfo result = new SyncInfo();
      result.channelRef = this.channelRef;
      result.channel = this.channel;
      result.externalId = this.externalId;
      result.syncedAt = this.syncedAt;
      return result;
    }

    public Builder channelRef(Reference channelRef) {
      this.channelRef = channelRef;
      return this;
    }

    public Builder channel(Channel channel) {
      this.channel = channel;
      return this;
    }

    public Builder externalId(String externalId) {
      this.externalId = externalId;
      return this;
    }

    public Builder syncedAt(OffsetDateTime syncedAt) {
      this.syncedAt = syncedAt;
      return this;
    }
  }
}
