package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class TaxCategoryChangeName {
  private String name;

  public TaxCategoryChangeName() {
  }

  public TaxCategoryChangeName(String name) {
    this.name = name;
  }

  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  @Override
  public String toString() {
    return "TaxCategoryChangeName{name='" + name + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    TaxCategoryChangeName that = (TaxCategoryChangeName) o;
    return Objects.equals(name, that.name);
  }

  @Override
  public int hashCode() {
    return Objects.hash(name);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String name;

    public TaxCategoryChangeName build() {
      TaxCategoryChangeName result = new TaxCategoryChangeName();
      result.name = this.name;
      return result;
    }

    public Builder name(String name) {
      this.name = name;
      return this;
    }
  }
}
