package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

public class TaxCategoryDraft {
  private String name;

  private String description;

  private List<TaxRateDraft> rates;

  private String key;

  public TaxCategoryDraft() {
  }

  public TaxCategoryDraft(String name, String description, List<TaxRateDraft> rates, String key) {
    this.name = name;
    this.description = description;
    this.rates = rates;
    this.key = key;
  }

  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = description;
  }

  public List<TaxRateDraft> getRates() {
    return rates;
  }

  public void setRates(List<TaxRateDraft> rates) {
    this.rates = rates;
  }

  public String getKey() {
    return key;
  }

  public void setKey(String key) {
    this.key = key;
  }

  @Override
  public String toString() {
    return "TaxCategoryDraft{name='" + name + "', description='" + description + "', rates='" + rates + "', key='" + key + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    TaxCategoryDraft that = (TaxCategoryDraft) o;
    return Objects.equals(name, that.name) &&
        Objects.equals(description, that.description) &&
        Objects.equals(rates, that.rates) &&
        Objects.equals(key, that.key);
  }

  @Override
  public int hashCode() {
    return Objects.hash(name, description, rates, key);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String name;

    private String description;

    private List<TaxRateDraft> rates;

    private String key;

    public TaxCategoryDraft build() {
      TaxCategoryDraft result = new TaxCategoryDraft();
      result.name = this.name;
      result.description = this.description;
      result.rates = this.rates;
      result.key = this.key;
      return result;
    }

    public Builder name(String name) {
      this.name = name;
      return this;
    }

    public Builder description(String description) {
      this.description = description;
      return this;
    }

    public Builder rates(List<TaxRateDraft> rates) {
      this.rates = rates;
      return this;
    }

    public Builder key(String key) {
      this.key = key;
      return this;
    }
  }
}
