package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class TaxCategoryUpdateAction {
  private TaxCategoryChangeName changeName;

  private TaxCategorySetDescription setDescription;

  private TaxCategoryAddTaxRate addTaxRate;

  private TaxCategoryReplaceTaxRate replaceTaxRate;

  private TaxCategoryRemoveTaxRate removeTaxRate;

  private SetTaxCategoryKey setKey;

  public TaxCategoryUpdateAction() {
  }

  public TaxCategoryUpdateAction(TaxCategoryChangeName changeName,
      TaxCategorySetDescription setDescription, TaxCategoryAddTaxRate addTaxRate,
      TaxCategoryReplaceTaxRate replaceTaxRate, TaxCategoryRemoveTaxRate removeTaxRate,
      SetTaxCategoryKey setKey) {
    this.changeName = changeName;
    this.setDescription = setDescription;
    this.addTaxRate = addTaxRate;
    this.replaceTaxRate = replaceTaxRate;
    this.removeTaxRate = removeTaxRate;
    this.setKey = setKey;
  }

  public TaxCategoryChangeName getChangeName() {
    return changeName;
  }

  public void setChangeName(TaxCategoryChangeName changeName) {
    this.changeName = changeName;
  }

  public TaxCategorySetDescription getSetDescription() {
    return setDescription;
  }

  public void setSetDescription(TaxCategorySetDescription setDescription) {
    this.setDescription = setDescription;
  }

  public TaxCategoryAddTaxRate getAddTaxRate() {
    return addTaxRate;
  }

  public void setAddTaxRate(TaxCategoryAddTaxRate addTaxRate) {
    this.addTaxRate = addTaxRate;
  }

  public TaxCategoryReplaceTaxRate getReplaceTaxRate() {
    return replaceTaxRate;
  }

  public void setReplaceTaxRate(TaxCategoryReplaceTaxRate replaceTaxRate) {
    this.replaceTaxRate = replaceTaxRate;
  }

  public TaxCategoryRemoveTaxRate getRemoveTaxRate() {
    return removeTaxRate;
  }

  public void setRemoveTaxRate(TaxCategoryRemoveTaxRate removeTaxRate) {
    this.removeTaxRate = removeTaxRate;
  }

  public SetTaxCategoryKey getSetKey() {
    return setKey;
  }

  public void setSetKey(SetTaxCategoryKey setKey) {
    this.setKey = setKey;
  }

  @Override
  public String toString() {
    return "TaxCategoryUpdateAction{changeName='" + changeName + "', setDescription='" + setDescription + "', addTaxRate='" + addTaxRate + "', replaceTaxRate='" + replaceTaxRate + "', removeTaxRate='" + removeTaxRate + "', setKey='" + setKey + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    TaxCategoryUpdateAction that = (TaxCategoryUpdateAction) o;
    return Objects.equals(changeName, that.changeName) &&
        Objects.equals(setDescription, that.setDescription) &&
        Objects.equals(addTaxRate, that.addTaxRate) &&
        Objects.equals(replaceTaxRate, that.replaceTaxRate) &&
        Objects.equals(removeTaxRate, that.removeTaxRate) &&
        Objects.equals(setKey, that.setKey);
  }

  @Override
  public int hashCode() {
    return Objects.hash(changeName, setDescription, addTaxRate, replaceTaxRate, removeTaxRate, setKey);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private TaxCategoryChangeName changeName;

    private TaxCategorySetDescription setDescription;

    private TaxCategoryAddTaxRate addTaxRate;

    private TaxCategoryReplaceTaxRate replaceTaxRate;

    private TaxCategoryRemoveTaxRate removeTaxRate;

    private SetTaxCategoryKey setKey;

    public TaxCategoryUpdateAction build() {
      TaxCategoryUpdateAction result = new TaxCategoryUpdateAction();
      result.changeName = this.changeName;
      result.setDescription = this.setDescription;
      result.addTaxRate = this.addTaxRate;
      result.replaceTaxRate = this.replaceTaxRate;
      result.removeTaxRate = this.removeTaxRate;
      result.setKey = this.setKey;
      return result;
    }

    public Builder changeName(TaxCategoryChangeName changeName) {
      this.changeName = changeName;
      return this;
    }

    public Builder setDescription(TaxCategorySetDescription setDescription) {
      this.setDescription = setDescription;
      return this;
    }

    public Builder addTaxRate(TaxCategoryAddTaxRate addTaxRate) {
      this.addTaxRate = addTaxRate;
      return this;
    }

    public Builder replaceTaxRate(TaxCategoryReplaceTaxRate replaceTaxRate) {
      this.replaceTaxRate = replaceTaxRate;
      return this;
    }

    public Builder removeTaxRate(TaxCategoryRemoveTaxRate removeTaxRate) {
      this.removeTaxRate = removeTaxRate;
      return this;
    }

    public Builder setKey(SetTaxCategoryKey setKey) {
      this.setKey = setKey;
      return this;
    }
  }
}
