package com.commercetools.graphql.api.types;

import java.lang.Boolean;
import java.lang.Double;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class TaxRateDraft {
  private String name;

  private Double amount;

  private Boolean includedInPrice;

  private String country;

  private String state;

  private List<SubRateDraft> subRates = Collections.emptyList();

  private String key;

  public TaxRateDraft() {
  }

  public TaxRateDraft(String name, Double amount, Boolean includedInPrice, String country,
      String state, List<SubRateDraft> subRates, String key) {
    this.name = name;
    this.amount = amount;
    this.includedInPrice = includedInPrice;
    this.country = country;
    this.state = state;
    this.subRates = subRates;
    this.key = key;
  }

  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public Double getAmount() {
    return amount;
  }

  public void setAmount(Double amount) {
    this.amount = amount;
  }

  public Boolean getIncludedInPrice() {
    return includedInPrice;
  }

  public void setIncludedInPrice(Boolean includedInPrice) {
    this.includedInPrice = includedInPrice;
  }

  public String getCountry() {
    return country;
  }

  public void setCountry(String country) {
    this.country = country;
  }

  public String getState() {
    return state;
  }

  public void setState(String state) {
    this.state = state;
  }

  public List<SubRateDraft> getSubRates() {
    return subRates;
  }

  public void setSubRates(List<SubRateDraft> subRates) {
    this.subRates = subRates;
  }

  public String getKey() {
    return key;
  }

  public void setKey(String key) {
    this.key = key;
  }

  @Override
  public String toString() {
    return "TaxRateDraft{name='" + name + "', amount='" + amount + "', includedInPrice='" + includedInPrice + "', country='" + country + "', state='" + state + "', subRates='" + subRates + "', key='" + key + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    TaxRateDraft that = (TaxRateDraft) o;
    return Objects.equals(name, that.name) &&
        Objects.equals(amount, that.amount) &&
        Objects.equals(includedInPrice, that.includedInPrice) &&
        Objects.equals(country, that.country) &&
        Objects.equals(state, that.state) &&
        Objects.equals(subRates, that.subRates) &&
        Objects.equals(key, that.key);
  }

  @Override
  public int hashCode() {
    return Objects.hash(name, amount, includedInPrice, country, state, subRates, key);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String name;

    private Double amount;

    private Boolean includedInPrice;

    private String country;

    private String state;

    private List<SubRateDraft> subRates = Collections.emptyList();

    private String key;

    public TaxRateDraft build() {
      TaxRateDraft result = new TaxRateDraft();
      result.name = this.name;
      result.amount = this.amount;
      result.includedInPrice = this.includedInPrice;
      result.country = this.country;
      result.state = this.state;
      result.subRates = this.subRates;
      result.key = this.key;
      return result;
    }

    public Builder name(String name) {
      this.name = name;
      return this;
    }

    public Builder amount(Double amount) {
      this.amount = amount;
      return this;
    }

    public Builder includedInPrice(Boolean includedInPrice) {
      this.includedInPrice = includedInPrice;
      return this;
    }

    public Builder country(String country) {
      this.country = country;
      return this;
    }

    public Builder state(String state) {
      this.state = state;
      return this;
    }

    public Builder subRates(List<SubRateDraft> subRates) {
      this.subRates = subRates;
      return this;
    }

    public Builder key(String key) {
      this.key = key;
      return this;
    }
  }
}
