package com.commercetools.graphql.api.types;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class TermCount {
  private String term;

  private Integer count;

  private Integer productCount;

  public TermCount() {
  }

  public TermCount(String term, Integer count, Integer productCount) {
    this.term = term;
    this.count = count;
    this.productCount = productCount;
  }

  public String getTerm() {
    return term;
  }

  public void setTerm(String term) {
    this.term = term;
  }

  public Integer getCount() {
    return count;
  }

  public void setCount(Integer count) {
    this.count = count;
  }

  public Integer getProductCount() {
    return productCount;
  }

  public void setProductCount(Integer productCount) {
    this.productCount = productCount;
  }

  @Override
  public String toString() {
    return "TermCount{term='" + term + "', count='" + count + "', productCount='" + productCount + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    TermCount that = (TermCount) o;
    return Objects.equals(term, that.term) &&
        Objects.equals(count, that.count) &&
        Objects.equals(productCount, that.productCount);
  }

  @Override
  public int hashCode() {
    return Objects.hash(term, count, productCount);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String term;

    private Integer count;

    private Integer productCount;

    public TermCount build() {
      TermCount result = new TermCount();
      result.term = this.term;
      result.count = this.count;
      result.productCount = this.productCount;
      return result;
    }

    public Builder term(String term) {
      this.term = term;
      return this;
    }

    public Builder count(Integer count) {
      this.count = count;
      return this;
    }

    public Builder productCount(Integer productCount) {
      this.productCount = productCount;
      return this;
    }
  }
}
