package com.commercetools.graphql.api.types;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class TermsFacetInput {
  private String path;

  private String alias;

  private Boolean countProducts = false;

  public TermsFacetInput() {
  }

  public TermsFacetInput(String path, String alias, Boolean countProducts) {
    this.path = path;
    this.alias = alias;
    this.countProducts = countProducts;
  }

  public String getPath() {
    return path;
  }

  public void setPath(String path) {
    this.path = path;
  }

  public String getAlias() {
    return alias;
  }

  public void setAlias(String alias) {
    this.alias = alias;
  }

  public Boolean getCountProducts() {
    return countProducts;
  }

  public void setCountProducts(Boolean countProducts) {
    this.countProducts = countProducts;
  }

  @Override
  public String toString() {
    return "TermsFacetInput{path='" + path + "', alias='" + alias + "', countProducts='" + countProducts + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    TermsFacetInput that = (TermsFacetInput) o;
    return Objects.equals(path, that.path) &&
        Objects.equals(alias, that.alias) &&
        Objects.equals(countProducts, that.countProducts);
  }

  @Override
  public int hashCode() {
    return Objects.hash(path, alias, countProducts);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String path;

    private String alias;

    private Boolean countProducts = false;

    public TermsFacetInput build() {
      TermsFacetInput result = new TermsFacetInput();
      result.path = this.path;
      result.alias = this.alias;
      result.countProducts = this.countProducts;
      return result;
    }

    public Builder path(String path) {
      this.path = path;
      return this;
    }

    public Builder alias(String alias) {
      this.alias = alias;
      return this;
    }

    public Builder countProducts(Boolean countProducts) {
      this.countProducts = countProducts;
      return this;
    }
  }
}
