package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class TermsFacetResult implements com.commercetools.graphql.api.types.FacetResult {
  private String dataType;

  private Integer missing;

  private Integer total;

  private Integer other;

  private List<TermCount> terms;

  private String type;

  public TermsFacetResult() {
  }

  public TermsFacetResult(String dataType, Integer missing, Integer total, Integer other,
      List<TermCount> terms, String type) {
    this.dataType = dataType;
    this.missing = missing;
    this.total = total;
    this.other = other;
    this.terms = terms;
    this.type = type;
  }

  public String getDataType() {
    return dataType;
  }

  public void setDataType(String dataType) {
    this.dataType = dataType;
  }

  public Integer getMissing() {
    return missing;
  }

  public void setMissing(Integer missing) {
    this.missing = missing;
  }

  public Integer getTotal() {
    return total;
  }

  public void setTotal(Integer total) {
    this.total = total;
  }

  public Integer getOther() {
    return other;
  }

  public void setOther(Integer other) {
    this.other = other;
  }

  public List<TermCount> getTerms() {
    return terms;
  }

  public void setTerms(List<TermCount> terms) {
    this.terms = terms;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "TermsFacetResult{dataType='" + dataType + "', missing='" + missing + "', total='" + total + "', other='" + other + "', terms='" + terms + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    TermsFacetResult that = (TermsFacetResult) o;
    return Objects.equals(dataType, that.dataType) &&
        Objects.equals(missing, that.missing) &&
        Objects.equals(total, that.total) &&
        Objects.equals(other, that.other) &&
        Objects.equals(terms, that.terms) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(dataType, missing, total, other, terms, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String dataType;

    private Integer missing;

    private Integer total;

    private Integer other;

    private List<TermCount> terms;

    private String type;

    public TermsFacetResult build() {
      TermsFacetResult result = new TermsFacetResult();
      result.dataType = this.dataType;
      result.missing = this.missing;
      result.total = this.total;
      result.other = this.other;
      result.terms = this.terms;
      result.type = this.type;
      return result;
    }

    public Builder dataType(String dataType) {
      this.dataType = dataType;
      return this;
    }

    public Builder missing(Integer missing) {
      this.missing = missing;
      return this;
    }

    public Builder total(Integer total) {
      this.total = total;
      return this;
    }

    public Builder other(Integer other) {
      this.other = other;
      return this;
    }

    public Builder terms(List<TermCount> terms) {
      this.terms = terms;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
