package com.commercetools.graphql.api.types;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class TrackingData {
  private String trackingId;

  private String carrier;

  private String provider;

  private String providerTransaction;

  private Boolean isReturn;

  public TrackingData() {
  }

  public TrackingData(String trackingId, String carrier, String provider,
      String providerTransaction, Boolean isReturn) {
    this.trackingId = trackingId;
    this.carrier = carrier;
    this.provider = provider;
    this.providerTransaction = providerTransaction;
    this.isReturn = isReturn;
  }

  public String getTrackingId() {
    return trackingId;
  }

  public void setTrackingId(String trackingId) {
    this.trackingId = trackingId;
  }

  public String getCarrier() {
    return carrier;
  }

  public void setCarrier(String carrier) {
    this.carrier = carrier;
  }

  public String getProvider() {
    return provider;
  }

  public void setProvider(String provider) {
    this.provider = provider;
  }

  public String getProviderTransaction() {
    return providerTransaction;
  }

  public void setProviderTransaction(String providerTransaction) {
    this.providerTransaction = providerTransaction;
  }

  public Boolean getIsReturn() {
    return isReturn;
  }

  public void setIsReturn(Boolean isReturn) {
    this.isReturn = isReturn;
  }

  @Override
  public String toString() {
    return "TrackingData{trackingId='" + trackingId + "', carrier='" + carrier + "', provider='" + provider + "', providerTransaction='" + providerTransaction + "', isReturn='" + isReturn + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    TrackingData that = (TrackingData) o;
    return Objects.equals(trackingId, that.trackingId) &&
        Objects.equals(carrier, that.carrier) &&
        Objects.equals(provider, that.provider) &&
        Objects.equals(providerTransaction, that.providerTransaction) &&
        Objects.equals(isReturn, that.isReturn);
  }

  @Override
  public int hashCode() {
    return Objects.hash(trackingId, carrier, provider, providerTransaction, isReturn);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String trackingId;

    private String carrier;

    private String provider;

    private String providerTransaction;

    private Boolean isReturn;

    public TrackingData build() {
      TrackingData result = new TrackingData();
      result.trackingId = this.trackingId;
      result.carrier = this.carrier;
      result.provider = this.provider;
      result.providerTransaction = this.providerTransaction;
      result.isReturn = this.isReturn;
      return result;
    }

    public Builder trackingId(String trackingId) {
      this.trackingId = trackingId;
      return this;
    }

    public Builder carrier(String carrier) {
      this.carrier = carrier;
      return this;
    }

    public Builder provider(String provider) {
      this.provider = provider;
      return this;
    }

    public Builder providerTransaction(String providerTransaction) {
      this.providerTransaction = providerTransaction;
      return this;
    }

    public Builder isReturn(Boolean isReturn) {
      this.isReturn = isReturn;
      return this;
    }
  }
}
